/*
 * Decompiled with CFR 0.152.
 */
package com.proofpoint.configuration;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.proofpoint.configuration.ConfigurationAwareModule;
import com.proofpoint.configuration.ConfigurationFactory;
import com.proofpoint.configuration.ConfigurationModule;

@Beta
public abstract class AbstractConfigurationAwareModule
implements ConfigurationAwareModule {
    private ConfigurationFactory configurationFactory;
    private Binder binder;

    @Override
    public synchronized void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = (ConfigurationFactory)Preconditions.checkNotNull((Object)configurationFactory, (Object)"configurationFactory is null");
    }

    public final synchronized void configure(Binder binder) {
        Preconditions.checkState((this.binder == null ? 1 : 0) != 0, (Object)"re-entry not allowed");
        this.binder = (Binder)Preconditions.checkNotNull((Object)binder, (Object)"binder is null");
        try {
            this.setup(binder);
        }
        finally {
            this.binder = null;
        }
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass) {
        ConfigurationModule.bindConfig(this.binder).to(configClass);
        return this.configurationFactory.build(configClass);
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass, String prefix) {
        ConfigurationModule.bindConfig(this.binder).prefixedWith(prefix).to(configClass);
        return this.configurationFactory.build(configClass, prefix);
    }

    protected synchronized void install(ConfigurationAwareModule module) {
        module.setConfigurationFactory(this.configurationFactory);
        this.binder.install((Module)module);
    }

    protected abstract void setup(Binder var1);
}

