/*
 * Decompiled with CFR 0.152.
 */
package shade.io.grpc.internal;

import com.pingcap.com.google.common.annotations.VisibleForTesting;
import com.pingcap.com.google.common.base.Preconditions;
import shade.io.grpc.Metadata;
import shade.io.grpc.Status;
import shade.io.grpc.internal.ClientStreamListener;
import shade.io.grpc.internal.InsightBuilder;
import shade.io.grpc.internal.NoopClientStream;

public final class FailingClientStream
extends NoopClientStream {
    private boolean started;
    private final Status error;
    private final ClientStreamListener.RpcProgress rpcProgress;

    public FailingClientStream(Status error) {
        this(error, ClientStreamListener.RpcProgress.PROCESSED);
    }

    public FailingClientStream(Status error, ClientStreamListener.RpcProgress rpcProgress) {
        Preconditions.checkArgument(!error.isOk(), "error must not be OK");
        this.error = error;
        this.rpcProgress = rpcProgress;
    }

    @Override
    public void start(ClientStreamListener listener) {
        Preconditions.checkState(!this.started, "already started");
        this.started = true;
        listener.closed(this.error, this.rpcProgress, new Metadata());
    }

    @VisibleForTesting
    Status getError() {
        return this.error;
    }

    @Override
    public void appendTimeoutInsight(InsightBuilder insight) {
        insight.appendKeyValue("error", this.error).appendKeyValue("progress", (Object)this.rpcProgress);
    }
}

