/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import com.pingcap.tikv.expression.AggregateFunction;
import com.pingcap.tikv.expression.ByItem;
import com.pingcap.tikv.expression.ColumnRef;
import com.pingcap.tikv.expression.ExpressionBlocklist;
import com.pingcap.tikv.expression.visitor.ColumnMatcher;
import com.pingcap.tikv.expression.visitor.MetaResolver;
import com.pingcap.tikv.expression.visitor.SupportedExpressionValidator;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.types.DataType;
import com.pingcap.tispark.TiDBRelation;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BasicExpression$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.DeclarativeAggregate;
import org.apache.spark.sql.catalyst.expressions.aggregate.First;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.expressions.aggregate.PromotedSum$;
import org.apache.spark.sql.catalyst.expressions.aggregate.SpecialSum;
import org.apache.spark.sql.catalyst.expressions.aggregate.Sum;
import org.apache.spark.sql.catalyst.expressions.aggregate.SumNotNullable$;
import org.apache.spark.sql.execution.TiConverter$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.Nothing$;

public final class TiExprUtils$ {
    public static final TiExprUtils$ MODULE$;

    static {
        new TiExprUtils$();
    }

    public void transformGroupingToTiGrouping(Expression expr, TiTableInfo meta, TiDAGRequest dagRequest) {
        Expression expression = expr;
        Option<com.pingcap.tikv.expression.Expression> option = BasicExpression$.MODULE$.unapply(expression);
        if (option.isEmpty()) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            com.pingcap.tikv.expression.Expression keyExpr = (com.pingcap.tikv.expression.Expression)option.get();
            MetaResolver.resolve(keyExpr, meta);
            dagRequest.addGroupByItem(ByItem.create(keyExpr, false));
            ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(dagRequest.getFields()).asScala()).filter((Function1)new Serializable(keyExpr){
                public static final long serialVersionUID = 0L;
                private final com.pingcap.tikv.expression.Expression keyExpr$1;

                public final boolean apply(ColumnRef x$1) {
                    return Predef$.MODULE$.Boolean2boolean(ColumnMatcher.match(x$1, this.keyExpr$1));
                }
                {
                    this.keyExpr$1 = keyExpr$1;
                }
            })).foreach((Function1)new Serializable(meta, dagRequest){
                public static final long serialVersionUID = 0L;
                private final TiTableInfo meta$1;
                private final TiDAGRequest dagRequest$1;

                public final TiDAGRequest apply(ColumnRef ref) {
                    return this.dagRequest$1.addAggregate(com.pingcap.tikv.expression.AggregateFunction.newCall(AggregateFunction.FunctionType.First, ref, this.meta$1.getColumn(ref.getName()).getType()));
                }
                {
                    this.meta$1 = meta$1;
                    this.dagRequest$1 = dagRequest$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Object transformAggExprToTiAgg(Expression expr, TiTableInfo meta, TiDAGRequest dagRequest) {
        First first;
        Expression expression;
        Option<com.pingcap.tikv.expression.Expression> option;
        Max max;
        Expression expression2;
        Option<com.pingcap.tikv.expression.Expression> option2;
        Min min;
        Expression expression3;
        Option<com.pingcap.tikv.expression.Expression> option3;
        Count count;
        Seq args;
        Expression expression4;
        Option<com.pingcap.tikv.expression.Expression> option4;
        SpecialSum specialSum;
        Option<Expression> option5;
        Object object;
        Sum sum;
        Expression expression5;
        Option<com.pingcap.tikv.expression.Expression> option6;
        Expression expression6 = expr;
        if (expression6 instanceof Average) {
            throw new IllegalArgumentException("Should never be here");
        }
        if (expression6 instanceof Sum && !(option6 = BasicExpression$.MODULE$.unapply(expression5 = (sum = (Sum)expression6).child())).isEmpty()) {
            com.pingcap.tikv.expression.Expression arg = (com.pingcap.tikv.expression.Expression)option6.get();
            object = this.addingSumAggToDAgReq(meta, dagRequest, (DeclarativeAggregate)sum, arg);
        } else if (expression6 instanceof SpecialSum && !(option5 = PromotedSum$.MODULE$.unapply(specialSum = (SpecialSum)expression6)).isEmpty() && !(option4 = BasicExpression$.MODULE$.unapply(expression4 = (Expression)option5.get())).isEmpty()) {
            com.pingcap.tikv.expression.Expression arg = (com.pingcap.tikv.expression.Expression)option4.get();
            object = this.addingSumAggToDAgReq(meta, dagRequest, specialSum, arg);
        } else if (expression6 instanceof Count && (args = (count = (Count)expression6).children()).lengthCompare(1) == 0) {
            com.pingcap.tikv.expression.Expression expression7;
            if (args.head() instanceof Literal) {
                ColumnRef columnRef;
                if (meta.hasPrimaryKey()) {
                    TiColumnInfo col = (TiColumnInfo)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(meta.getColumns()).asScala()).filter((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(TiColumnInfo col) {
                            return col.isPrimaryKey();
                        }
                    })).head();
                    columnRef = ColumnRef.create(col.getName(), meta);
                } else if (dagRequest.getFields().isEmpty()) {
                    TiColumnInfo firstCol = meta.getColumns().get(0);
                    columnRef = ColumnRef.create(firstCol.getName(), meta);
                } else {
                    columnRef = (ColumnRef)JavaConversions$.MODULE$.asScalaBuffer(dagRequest.getFields()).head();
                }
                ColumnRef firstColRef = columnRef;
                dagRequest.addRequiredColumn(firstColRef);
                expression7 = firstColRef;
            } else {
                expression7 = (com.pingcap.tikv.expression.Expression)((IterableLike)args.flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Iterable<com.pingcap.tikv.expression.Expression> apply(Expression expr) {
                        return Option$.MODULE$.option2Iterable(BasicExpression$.MODULE$.convertToTiExpr(expr));
                    }
                }, Seq$.MODULE$.canBuildFrom())).head();
            }
            com.pingcap.tikv.expression.Expression tiArg = expression7;
            object = dagRequest.addAggregate(com.pingcap.tikv.expression.AggregateFunction.newCall(AggregateFunction.FunctionType.Count, tiArg, TiConverter$.MODULE$.fromSparkType(count.dataType())));
        } else if (expression6 instanceof Min && !(option3 = BasicExpression$.MODULE$.unapply(expression3 = (min = (Min)expression6).child())).isEmpty()) {
            com.pingcap.tikv.expression.Expression arg = (com.pingcap.tikv.expression.Expression)option3.get();
            MetaResolver.resolve(arg, meta);
            object = dagRequest.addAggregate(com.pingcap.tikv.expression.AggregateFunction.newCall(AggregateFunction.FunctionType.Min, arg));
        } else if (expression6 instanceof Max && !(option2 = BasicExpression$.MODULE$.unapply(expression2 = (max = (Max)expression6).child())).isEmpty()) {
            com.pingcap.tikv.expression.Expression arg = (com.pingcap.tikv.expression.Expression)option2.get();
            MetaResolver.resolve(arg, meta);
            object = dagRequest.addAggregate(com.pingcap.tikv.expression.AggregateFunction.newCall(AggregateFunction.FunctionType.Max, arg));
        } else if (expression6 instanceof First && !(option = BasicExpression$.MODULE$.unapply(expression = (first = (First)expression6).child())).isEmpty()) {
            com.pingcap.tikv.expression.Expression arg = (com.pingcap.tikv.expression.Expression)option.get();
            MetaResolver.resolve(arg, meta);
            object = dagRequest.addAggregate(com.pingcap.tikv.expression.AggregateFunction.newCall(AggregateFunction.FunctionType.First, arg));
        } else {
            object = BoxedUnit.UNIT;
        }
        return object;
    }

    private TiDAGRequest addingSumAggToDAgReq(TiTableInfo meta, TiDAGRequest dagRequest, DeclarativeAggregate f, com.pingcap.tikv.expression.Expression arg) {
        MetaResolver.resolve(arg, meta);
        return dagRequest.addAggregate(com.pingcap.tikv.expression.AggregateFunction.newCall(AggregateFunction.FunctionType.Sum, arg, TiConverter$.MODULE$.fromSparkType(f.dataType())));
    }

    public com.pingcap.tikv.expression.Expression transformFilter(Expression expr, TiTableInfo meta, TiDAGRequest dagRequest) {
        Expression expression = expr;
        Option<com.pingcap.tikv.expression.Expression> option = BasicExpression$.MODULE$.unapply(expression);
        if (option.isEmpty()) {
            throw new MatchError((Object)expression);
        }
        com.pingcap.tikv.expression.Expression arg = (com.pingcap.tikv.expression.Expression)option.get();
        MetaResolver.resolve(arg, meta);
        com.pingcap.tikv.expression.Expression expression2 = arg;
        return expression2;
    }

    public void transformSortOrderToTiOrderBy(TiDAGRequest request, Seq<SortOrder> sortOrder, TiTableInfo meta) {
        Seq byItems = (Seq)sortOrder.map((Function1)new Serializable(meta){
            public static final long serialVersionUID = 0L;
            private final TiTableInfo meta$2;

            public final ByItem apply(SortOrder order) {
                com.pingcap.tikv.expression.Expression arg;
                com.pingcap.tikv.expression.Expression expression;
                Expression expr = order.child();
                Expression expression2 = expr;
                Option<com.pingcap.tikv.expression.Expression> option = BasicExpression$.MODULE$.unapply(expression2);
                if (option.isEmpty()) {
                    throw new MatchError((Object)expression2);
                }
                com.pingcap.tikv.expression.Expression tiExpr = expression = (arg = (com.pingcap.tikv.expression.Expression)option.get());
                MetaResolver.resolve(tiExpr, this.meta$2);
                return ByItem.create(tiExpr, order.direction().sql().equalsIgnoreCase("DESC"));
            }
            {
                this.meta$2 = meta$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        byItems.foreach((Function1)new Serializable(request){
            public static final long serialVersionUID = 0L;
            private final TiDAGRequest request$1;

            public final TiDAGRequest apply(ByItem x$1) {
                return this.request$1.addOrderByItem(x$1);
            }
            {
                this.request$1 = request$1;
            }
        });
    }

    public com.pingcap.tikv.expression.Expression transformAttrToColRef(Attribute attr, TiTableInfo meta) {
        Attribute attribute = attr;
        Option<com.pingcap.tikv.expression.Expression> option = BasicExpression$.MODULE$.unapply((Expression)attribute);
        if (option.isEmpty()) {
            throw new MatchError((Object)attribute);
        }
        com.pingcap.tikv.expression.Expression expr = (com.pingcap.tikv.expression.Expression)option.get();
        MetaResolver.resolve(expr, meta);
        com.pingcap.tikv.expression.Expression expression = expr;
        return expression;
    }

    public boolean isSupportedAggregate(AggregateExpression aggExpr, TiDBRelation tiDBRelation, ExpressionBlocklist blocklist) {
        SpecialSum specialSum;
        Option<Expression> option;
        SpecialSum specialSum2;
        Option<Expression> option2;
        AggregateFunction aggregateFunction = aggExpr.aggregateFunction();
        boolean bl = aggregateFunction instanceof Average ? true : (aggregateFunction instanceof Sum ? true : (aggregateFunction instanceof SpecialSum && !(option2 = SumNotNullable$.MODULE$.unapply(specialSum2 = (SpecialSum)aggregateFunction)).isEmpty() ? true : (aggregateFunction instanceof SpecialSum && !(option = PromotedSum$.MODULE$.unapply(specialSum = (SpecialSum)aggregateFunction)).isEmpty() ? true : (aggregateFunction instanceof Min ? true : aggregateFunction instanceof Max))));
        boolean bl2 = bl ? !aggExpr.isDistinct() && aggExpr.aggregateFunction().children().forall((Function1)new Serializable(tiDBRelation, blocklist){
            public static final long serialVersionUID = 0L;
            private final TiDBRelation tiDBRelation$1;
            private final ExpressionBlocklist blocklist$1;

            public final boolean apply(Expression x$2) {
                return TiExprUtils$.MODULE$.isSupportedBasicExpression(x$2, this.tiDBRelation$1, this.blocklist$1);
            }
            {
                this.tiDBRelation$1 = tiDBRelation$1;
                this.blocklist$1 = blocklist$1;
            }
        }) : false;
        return bl2;
    }

    public boolean isSupportedBasicExpression(Expression expr, TiDBRelation tiDBRelation, ExpressionBlocklist blocklist) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            boolean bl;
            Object object = new Object();
            try {
                if (!BasicExpression$.MODULE$.isSupportedExpression(expr, RegionStoreClient.RequestTypes.REQ_TYPE_DAG)) {
                    return false;
                }
                bl = BoxesRunTime.unboxToBoolean((Object)BasicExpression$.MODULE$.convertToTiExpr(expr).fold((Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply() {
                        return this.apply$mcZ$sp();
                    }

                    public boolean apply$mcZ$sp() {
                        return false;
                    }
                }, (Function1)new Serializable(tiDBRelation, blocklist, object){
                    public static final long serialVersionUID = 0L;
                    private final TiDBRelation tiDBRelation$2;
                    private final ExpressionBlocklist blocklist$2;
                    private final Object nonLocalReturnKey1$1;

                    public final Nothing$ apply(com.pingcap.tikv.expression.Expression expr) {
                        MetaResolver.resolve(expr, this.tiDBRelation$2.table());
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey1$1, SupportedExpressionValidator.isSupportedExpression(expr, this.blocklist$2));
                    }
                    {
                        this.tiDBRelation$2 = tiDBRelation$2;
                        this.blocklist$2 = blocklist$2;
                        this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                    }
                }));
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public boolean isPushDownSupported(Expression expr, TiDBRelation source) {
        NonLocalReturnControl nonLocalReturnControl2;
        block5: {
            boolean bl;
            Object object = new Object();
            try {
                HashMap nameTypeMap = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
                JavaConversions$.MODULE$.asScalaBuffer(source.table().getColumns()).foreach((Function1)new Serializable(nameTypeMap){
                    public static final long serialVersionUID = 0L;
                    private final HashMap nameTypeMap$1;

                    public final void apply(TiColumnInfo info) {
                        this.nameTypeMap$1.update((Object)info.getName(), (Object)info.getType());
                    }
                    {
                        this.nameTypeMap$1 = nameTypeMap$1;
                    }
                });
                if (expr.children().isEmpty()) {
                    AttributeReference attributeReference;
                    Expression expression = expr;
                    if (expression instanceof AttributeReference && nameTypeMap.contains((Object)(attributeReference = (AttributeReference)expression).name())) {
                        return ((DataType)Option$.MODULE$.option2Iterable(nameTypeMap.get((Object)attributeReference.name())).head()).isPushDownSupported();
                    }
                    if (expression instanceof Literal) {
                        Literal literal = (Literal)expression;
                        return literal.value() != null;
                    }
                    return true;
                }
                expr.children().foreach((Function1)new Serializable(source, object){
                    public static final long serialVersionUID = 0L;
                    private final TiDBRelation source$1;
                    private final Object nonLocalReturnKey2$1;

                    public final void apply(Expression expr) {
                        if (TiExprUtils$.MODULE$.isPushDownSupported(expr, this.source$1)) {
                            return;
                        }
                        throw new NonLocalReturnControl.mcZ.sp(this.nonLocalReturnKey2$1, false);
                    }
                    {
                        this.source$1 = source$1;
                        this.nonLocalReturnKey2$1 = nonLocalReturnKey2$1;
                    }
                });
                bl = true;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block5;
                bl = nonLocalReturnControl2.value$mcZ$sp();
            }
            return bl;
        }
        throw nonLocalReturnControl2;
    }

    public boolean isSupportedOrderBy(Expression expr, TiDBRelation source, ExpressionBlocklist blocklist) {
        return this.isSupportedBasicExpression(expr, source, blocklist) && this.isPushDownSupported(expr, source);
    }

    public boolean isSupportedFilter(Expression expr, TiDBRelation source, ExpressionBlocklist blocklist) {
        return this.isSupportedBasicExpression(expr, source, blocklist) && this.isPushDownSupported(expr, source);
    }

    public boolean isSupportedGroupingExpr(NamedExpression expr, TiDBRelation source, ExpressionBlocklist blocklist) {
        return this.isSupportedBasicExpression((Expression)expr, source, blocklist) && this.isPushDownSupported((Expression)expr, source);
    }

    private TiExprUtils$() {
        MODULE$ = this;
    }
}

