/*
 * Decompiled with CFR 0.152.
 */
package io.etcd.jetcd.common.exception;

import com.pingcap.com.google.common.base.Preconditions;
import io.etcd.jetcd.common.exception.ClosedClientException;
import io.etcd.jetcd.common.exception.ClosedKeepAliveListenerException;
import io.etcd.jetcd.common.exception.ClosedSnapshotException;
import io.etcd.jetcd.common.exception.ClosedWatcherException;
import io.etcd.jetcd.common.exception.CompactedException;
import io.etcd.jetcd.common.exception.ErrorCode;
import io.etcd.jetcd.common.exception.EtcdException;
import shade.io.grpc.Status;

public final class EtcdExceptionFactory {
    public static EtcdException newEtcdException(ErrorCode code, String message) {
        return new EtcdException(code, message, null);
    }

    public static EtcdException newEtcdException(ErrorCode code, String message, Throwable cause) {
        return new EtcdException(code, message, cause);
    }

    public static CompactedException newCompactedException(long compactedRev) {
        return new CompactedException(ErrorCode.OUT_OF_RANGE, "etcdserver: mvcc: required revision has been compacted", compactedRev);
    }

    public static ClosedWatcherException newClosedWatcherException() {
        return new ClosedWatcherException();
    }

    public static ClosedClientException newClosedWatchClientException() {
        return new ClosedClientException("Watch Client has been closed");
    }

    public static ClosedClientException newClosedLeaseClientException() {
        return new ClosedClientException("Lease Client has been closed");
    }

    public static ClosedKeepAliveListenerException newClosedKeepAliveListenerException() {
        return new ClosedKeepAliveListenerException();
    }

    public static ClosedSnapshotException newClosedSnapshotException() {
        return new ClosedSnapshotException();
    }

    public static EtcdException handleInterrupt(InterruptedException e) {
        Thread.currentThread().interrupt();
        return EtcdExceptionFactory.newEtcdException(ErrorCode.CANCELLED, "Interrupted", e);
    }

    public static EtcdException toEtcdException(Throwable cause) {
        Preconditions.checkNotNull(cause, "cause can't be null");
        if (cause instanceof EtcdException) {
            return (EtcdException)cause;
        }
        return EtcdExceptionFactory.toEtcdException(Status.fromThrowable(cause));
    }

    public static EtcdException toEtcdException(Status status) {
        Preconditions.checkNotNull(status, "status can't be null");
        return EtcdExceptionFactory.fromStatus(status);
    }

    private static EtcdException fromStatus(Status status) {
        return EtcdExceptionFactory.newEtcdException(ErrorCode.fromGrpcStatus(status), status.getDescription(), status.getCause());
    }
}

