/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tispark.utils;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.datatype.TypeMapping;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.meta.TiDAGRequest;
import com.pingcap.tikv.meta.TiTableInfo;
import com.pingcap.tikv.region.TiStoreType;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tispark.TiConfigConst$;
import com.pingcap.tispark.TiSparkInfo$;
import com.pingcap.tispark.TiSparkVersion$;
import com.pingcap.tispark.utils.TiUtil$;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.MetadataBuilder;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.tikv.kvproto.Kvrpcpb;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;

public final class TiUtil$ {
    public static final TiUtil$ MODULE$;

    static {
        new TiUtil$();
    }

    public StructType getSchemaFromTable(TiTableInfo table) {
        StructField[] fields = new StructField[table.getColumns().size()];
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), table.getColumns().size()).foreach$mVc$sp((Function1)new Serializable(table, fields){
            public static final long serialVersionUID = 0L;
            private final TiTableInfo table$1;
            private final StructField[] fields$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                TiColumnInfo col = this.table$1.getColumns().get(i);
                boolean notNull = col.getType().isNotNull();
                Metadata metadata = new MetadataBuilder().putString("name", col.getName()).build();
                this.fields$1[i] = new StructField(col.getName(), TypeMapping.toSparkType(col.getType()), !notNull, metadata);
            }
            {
                this.table$1 = table$1;
                this.fields$1 = fields$1;
            }
        });
        return new StructType(fields);
    }

    public boolean isDataFrameEmpty(Dataset<Row> df) {
        return df.rdd().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public TiConfiguration sparkConfToTiConf(SparkConf conf) {
        void var2_2;
        Object object;
        TiConfiguration tiConf = TiConfiguration.createDefault(conf.get(TiConfigConst$.MODULE$.PD_ADDRESSES()));
        Object object2 = conf.contains(TiConfigConst$.MODULE$.GRPC_FRAME_SIZE()) ? tiConf.setMaxFrameSize(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.GRPC_FRAME_SIZE()))).toInt()) : BoxedUnit.UNIT;
        if (conf.contains(TiConfigConst$.MODULE$.GRPC_TIMEOUT())) {
            tiConf.setTimeout(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.GRPC_TIMEOUT()))).toInt());
            object = tiConf.setTimeoutUnit(TimeUnit.SECONDS);
        } else {
            object = BoxedUnit.UNIT;
        }
        if (conf.contains(TiConfigConst$.MODULE$.INDEX_SCAN_BATCH_SIZE())) {
            tiConf.setIndexScanBatchSize(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.INDEX_SCAN_BATCH_SIZE()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.INDEX_SCAN_CONCURRENCY())) {
            tiConf.setIndexScanConcurrency(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.INDEX_SCAN_CONCURRENCY()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.TABLE_SCAN_CONCURRENCY())) {
            tiConf.setTableScanConcurrency(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.TABLE_SCAN_CONCURRENCY()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.REQUEST_ISOLATION_LEVEL())) {
            String isolationLevel = conf.get(TiConfigConst$.MODULE$.REQUEST_ISOLATION_LEVEL());
            if (isolationLevel.equals(TiConfigConst$.MODULE$.SNAPSHOT_ISOLATION_LEVEL())) {
                tiConf.setIsolationLevel(Kvrpcpb.IsolationLevel.SI);
            } else {
                tiConf.setIsolationLevel(Kvrpcpb.IsolationLevel.RC);
            }
        }
        if (conf.contains(TiConfigConst$.MODULE$.REQUEST_COMMAND_PRIORITY())) {
            Kvrpcpb.CommandPri priority = Kvrpcpb.CommandPri.valueOf(conf.get(TiConfigConst$.MODULE$.REQUEST_COMMAND_PRIORITY()));
            tiConf.setCommandPriority(priority);
        }
        if (conf.contains(TiConfigConst$.MODULE$.SHOW_ROWID())) {
            tiConf.setShowRowId(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.SHOW_ROWID()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.DB_PREFIX())) {
            tiConf.setDBPrefix(conf.get(TiConfigConst$.MODULE$.DB_PREFIX()));
        }
        if (conf.contains(TiConfigConst$.MODULE$.WRITE_ENABLE())) {
            tiConf.setWriteEnable(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.WRITE_ENABLE()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.WRITE_WITHOUT_LOCK_TABLE())) {
            tiConf.setWriteWithoutLockTable(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.WRITE_WITHOUT_LOCK_TABLE()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.WRITE_ALLOW_SPARK_SQL())) {
            tiConf.setWriteAllowSparkSQL(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.WRITE_ALLOW_SPARK_SQL()))).toBoolean());
        }
        if (conf.contains(TiConfigConst$.MODULE$.TIKV_REGION_SPLIT_SIZE_IN_MB())) {
            tiConf.setTikvRegionSplitSizeInMB(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.TIKV_REGION_SPLIT_SIZE_IN_MB()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.REGION_INDEX_SCAN_DOWNGRADE_THRESHOLD())) {
            tiConf.setDowngradeThreshold(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.REGION_INDEX_SCAN_DOWNGRADE_THRESHOLD()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.PARTITION_PER_SPLIT())) {
            tiConf.setPartitionPerSplit(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.PARTITION_PER_SPLIT()))).toInt());
        }
        if (conf.contains(TiConfigConst$.MODULE$.ISOLATION_READ_ENGINES())) {
            tiConf.setIsolationReadEngines(JavaConversions$.MODULE$.seqAsJavaList((Seq)this.getIsolationReadEnginesFromString(conf.get(TiConfigConst$.MODULE$.ISOLATION_READ_ENGINES())).toList()));
        }
        if (conf.contains(TiConfigConst$.MODULE$.KV_CLIENT_CONCURRENCY())) {
            tiConf.setKvClientConcurrency(new StringOps(Predef$.MODULE$.augmentString(conf.get(TiConfigConst$.MODULE$.KV_CLIENT_CONCURRENCY()))).toInt());
        }
        return var2_2;
    }

    private List<TiStoreType> getIsolationReadEnginesFromString(String str) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])str.toLowerCase().split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TiStoreType apply(String x0$1) {
                String string;
                block4: {
                    TiStoreType tiStoreType;
                    block3: {
                        block2: {
                            string = x0$1;
                            String string2 = TiConfigConst$.MODULE$.TIKV_STORAGE_ENGINE();
                            String string3 = string;
                            if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                            tiStoreType = TiStoreType.TiKV;
                            break block3;
                        }
                        String string4 = TiConfigConst$.MODULE$.TIFLASH_STORAGE_ENGINE();
                        String string5 = string;
                        if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                        tiStoreType = TiStoreType.TiFlash;
                    }
                    return tiStoreType;
                }
                throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown isolation engine type: ", ", valid types are 'tikv, tiflash'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string})));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(TiStoreType.class)))).toList();
    }

    public int getChunkBatchSize(SQLContext sqlContext) {
        return new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf(TiConfigConst$.MODULE$.CHUNK_BATCH_SIZE(), "1024"))).toInt();
    }

    public int getPartitionPerSplit(SQLContext sqlContext) {
        return new StringOps(Predef$.MODULE$.augmentString(sqlContext.getConf(TiConfigConst$.MODULE$.PARTITION_PER_SPLIT(), "1"))).toInt();
    }

    public List<TiStoreType> getIsolationReadEngines(SQLContext sqlContext) {
        return this.getIsolationReadEnginesFromString(sqlContext.getConf(TiConfigConst$.MODULE$.ISOLATION_READ_ENGINES(), TiConfigConst$.MODULE$.DEFAULT_STORAGE_ENGINES()));
    }

    public void registerUDFs(SparkSession sparkSession) {
        String timeZoneStr = new StringBuilder().append((Object)"TimeZone: ").append((Object)Converter.getLocalTimezone().toString()).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_pingcap_tispark_utils_TiUtil$$typecreator1$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Com_pingcap_tispark_utils_TiUtil$$typecreator1$1() {
            }
        }
        sparkSession.udf().register("ti_version", (Function0)new Serializable(timeZoneStr){
            public static final long serialVersionUID = 0L;
            private final String timeZoneStr$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\n", "\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{TiSparkVersion$.MODULE$.version(), TiSparkInfo$.MODULE$.info(), this.timeZoneStr$1}));
            }
            {
                this.timeZoneStr$1 = timeZoneStr$1;
            }
        }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Com_pingcap_tispark_utils_TiUtil$$typecreator1$1()));
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_pingcap_tispark_utils_TiUtil$$typecreator2$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Com_pingcap_tispark_utils_TiUtil$$typecreator2$1() {
            }
        }
        sparkSession.udf().register("time_to_str", (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(long value, int frac) {
                return Converter.convertDurationToStr(value, frac);
            }
        }, ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Com_pingcap_tispark_utils_TiUtil$$typecreator2$1()), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Int());
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Com_pingcap_tispark_utils_TiUtil$$typecreator3$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticModule("scala.Predef")), (Symbols.SymbolApi)$u.internal().reificationSupport().selectType($m.staticModule("scala.Predef").asModule().moduleClass(), "String"), (List)Nil$.MODULE$);
            }

            public Com_pingcap_tispark_utils_TiUtil$$typecreator3$1() {
            }
        }
        sparkSession.udf().register("str_to_time", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(String value) {
                return Converter.convertStrToDuration(value);
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Long(), ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Com_pingcap_tispark_utils_TiUtil$$typecreator3$1()));
    }

    public String getReqEstCountStr(TiDAGRequest req) {
        String string;
        if (req.getEstimatedCount() > 0.0) {
            DecimalFormat df = new DecimalFormat("#.#");
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" EstimatedCount:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{df.format(req.getEstimatedCount())}));
        } else {
            string = "";
        }
        return string;
    }

    public InternalRow rowToInternalRow(Row row, Seq<DataType> outputTypes, Seq<Function1<Object, Object>> converters) {
        GenericInternalRow mutableRow = new GenericInternalRow(outputTypes.length());
        outputTypes.indices().foreach$mVc$sp((Function1)new Serializable(row, converters, mutableRow){
            public static final long serialVersionUID = 0L;
            private final Row row$1;
            private final Seq converters$1;
            private final GenericInternalRow mutableRow$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.mutableRow$1.update(i, ((Function1)this.converters$1.apply(i)).apply(this.row$1.apply(i)));
            }
            {
                this.row$1 = row$1;
                this.converters$1 = converters$1;
                this.mutableRow$1 = mutableRow$1;
            }
        });
        return mutableRow;
    }

    private TiUtil$() {
        MODULE$ = this;
    }
}

