/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tispark.handler;

import com.pingcap.tikv.event.CacheInvalidateEvent;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tispark.handler.CacheInvalidateEventHandler$;
import com.pingcap.tispark.listener.CacheInvalidateListener$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u001d3A!\u0001\u0002\u0001\u0017\tY2)Y2iK&sg/\u00197jI\u0006$X-\u0012<f]RD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000f!\fg\u000e\u001a7fe*\u0011QAB\u0001\bi&\u001c\b/\u0019:l\u0015\t9\u0001\"A\u0004qS:<7-\u00199\u000b\u0003%\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011!\u0019\u0002A!A!\u0002\u0013!\u0012!\u0004:fO&|g.T1oC\u001e,'\u000f\u0005\u0002\u001655\taC\u0003\u0002\u00181\u00051!/Z4j_:T!!\u0007\u0004\u0002\tQL7N^\u0005\u00037Y\u0011QBU3hS>tW*\u00198bO\u0016\u0014\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\b\u0006\u0002 CA\u0011\u0001\u0005A\u0007\u0002\u0005!)1\u0003\ba\u0001)!91\u0005\u0001b\u0001\n\u001b!\u0013A\u00027pO\u001e,'/F\u0001&!\t13&D\u0001(\u0015\tA\u0013&A\u0003tY\u001a$$NC\u0001+\u0003\ry'oZ\u0005\u0003Y\u001d\u0012a\u0001T8hO\u0016\u0014\bB\u0002\u0018\u0001A\u00035Q%A\u0004m_\u001e<WM\u001d\u0011\t\u000bA\u0002A\u0011A\u0019\u0002\r!\fg\u000e\u001a7f)\t\u0011T\u0007\u0005\u0002\u000eg%\u0011AG\u0004\u0002\u0005+:LG\u000fC\u00037_\u0001\u0007q'A\u0003fm\u0016tG\u000f\u0005\u00029u5\t\u0011H\u0003\u000271%\u00111(\u000f\u0002\u0015\u0007\u0006\u001c\u0007.Z%om\u0006d\u0017\u000eZ1uK\u00163XM\u001c;\b\u000bu\u0012\u0001\u0012\u0001 \u00027\r\u000b7\r[3J]Z\fG.\u001b3bi\u0016,e/\u001a8u\u0011\u0006tG\r\\3s!\t\u0001sHB\u0003\u0002\u0005!\u0005\u0001i\u0005\u0002@\u0019!)Qd\u0010C\u0001\u0005R\ta\bC\u0003E\u007f\u0011\u0005Q)A\u0003baBd\u0017\u0010\u0006\u0002 \r\")1c\u0011a\u0001)\u0001")
public class CacheInvalidateEventHandler {
    private final RegionManager regionManager;
    private final Logger logger;

    public static CacheInvalidateEventHandler apply(RegionManager regionManager) {
        return CacheInvalidateEventHandler$.MODULE$.apply(regionManager);
    }

    private final Logger logger() {
        return this.logger;
    }

    public void handle(CacheInvalidateEvent event) {
        block9: {
            block8: {
                try {
                    Object object;
                    CacheInvalidateEvent.CacheType cacheType = event.getCacheType();
                    if (CacheInvalidateEvent.CacheType.REGION_STORE.equals(cacheType)) {
                        BoxedUnit boxedUnit;
                        if (event.shouldUpdateRegion()) {
                            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalidating region ", " cache at driver."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)event.getRegionId())})));
                            this.regionManager.invalidateRegion(event.getRegionId());
                        }
                        if (event.shouldUpdateStore()) {
                            this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalidating store ", " cache at driver."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)event.getStoreId())})));
                            this.regionManager.invalidateStore(event.getStoreId());
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                        break block8;
                    }
                    if (CacheInvalidateEvent.CacheType.LEADER.equals(cacheType)) {
                        this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalidating leader of region:", " store:", " cache at driver."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)event.getRegionId()), BoxesRunTime.boxToLong((long)event.getStoreId())})));
                        object = BoxesRunTime.boxToBoolean((boolean)this.regionManager.updateLeader(event.getRegionId(), event.getStoreId()));
                        break block8;
                    }
                    if (!CacheInvalidateEvent.CacheType.REQ_FAILED.equals(cacheType)) break block9;
                    this.logger().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Request failed cache invalidation for region ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)event.getRegionId())})));
                    this.regionManager.onRequestFail(event.getRegionId(), event.getStoreId());
                    object = BoxedUnit.UNIT;
                }
                catch (Exception exception) {
                    this.logger().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updating cache failed:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})));
                    return;
                }
            }
            CacheInvalidateListener$.MODULE$.getInstance().CACHE_INVALIDATE_ACCUMULATOR().remove(event);
            return;
        }
        throw new IllegalArgumentException("Unsupported cache invalidate type.");
    }

    public CacheInvalidateEventHandler(RegionManager regionManager) {
        this.regionManager = regionManager;
        this.logger = LoggerFactory.getLogger((String)this.getClass().getName());
    }
}

