/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum MySQLType {
    TypeDecimal(0, 16L, 1, 11),
    TypeTiny(1, 1L, 1, 4),
    TypeShort(2, 2L, 1, 6),
    TypeLong(3, 4L, 1, 11),
    TypeFloat(4, 4L, 1, -1),
    TypeDouble(5, 8L, 1, -1),
    TypeNull(6, 8L, 1, -1),
    TypeTimestamp(7, 32L, 1, -1),
    TypeLonglong(8, 8L, 1, 20),
    TypeInt24(9, 3L, 1, 9),
    TypeDate(10, 3L, 1, -1),
    TypeDuration(11, 8L, 1, -1),
    TypeDatetime(12, 8L, 1, -1),
    TypeYear(13, 8L, 1, 4),
    TypeNewDate(14, 8L, 1, -1),
    TypeVarchar(15, 255L, 2, -1),
    TypeBit(16, 1L, 1, 1),
    TypeJSON(245, 1024L, 1, -1),
    TypeNewDecimal(246, 32L, 1, 11),
    TypeEnum(247, 8L, 1, -1),
    TypeSet(248, 8L, 1, -1),
    TypeTinyBlob(249, 255L, 2, -1),
    TypeMediumBlob(250, 21777215L, 3, -1),
    TypeLongBlob(251, 0xFFFFFFFFL, 4, -1),
    TypeBlob(252, 65535L, 2, -1),
    TypeVarString(253, 255L, 1, -1),
    TypeString(254, 255L, 1, 1),
    TypeGeometry(255, 1024L, 1, -1);

    private static final Map<Integer, MySQLType> typeMap;
    private static final Map<Integer, Long> sizeMap;
    private final int typeCode;
    private final long defaultSize;
    private final int prefixSize;
    private final int defaultLength;

    private MySQLType(int tp, long sz, int lengthSz, int M) {
        this.typeCode = tp;
        this.defaultSize = sz;
        this.prefixSize = lengthSz;
        this.defaultLength = M;
    }

    public static MySQLType fromTypeCode(int typeCode) {
        MySQLType type = typeMap.get(typeCode);
        return Objects.requireNonNull(type, String.format("Cannot find Type from type code %d", typeCode));
    }

    public static long getTypeDefaultSize(int typeCode) {
        Long size = sizeMap.get(typeCode);
        return Objects.requireNonNull(size, String.format("Cannot find default size from type code %d", typeCode));
    }

    public int getTypeCode() {
        return this.typeCode;
    }

    public long getDefaultSize() {
        return this.defaultSize;
    }

    public long getPrefixSize() {
        return this.prefixSize;
    }

    public int getDefaultLength() {
        return this.defaultLength;
    }

    static {
        typeMap = new HashMap<Integer, MySQLType>();
        sizeMap = new HashMap<Integer, Long>();
        for (MySQLType type : MySQLType.values()) {
            typeMap.put(type.getTypeCode(), type);
        }
        for (MySQLType type : MySQLType.values()) {
            sizeMap.put(type.getTypeCode(), type.defaultSize);
        }
    }
}

