/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.types;

import com.pingcap.tikv.codec.Codec;
import com.pingcap.tikv.codec.CodecDataInput;
import com.pingcap.tikv.codec.CodecDataOutput;
import com.pingcap.tikv.exception.ConvertNotSupportException;
import com.pingcap.tikv.exception.ConvertOverflowException;
import com.pingcap.tikv.meta.TiColumnInfo;
import com.pingcap.tikv.types.AbstractDateTimeType;
import com.pingcap.tikv.types.Converter;
import com.pingcap.tikv.types.MySQLType;
import java.sql.Date;
import java.sql.Timestamp;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalDate;

public class DateType
extends AbstractDateTimeType {
    private static final LocalDate EPOCH = new LocalDate(0L);
    public static final DateType DATE = new DateType(MySQLType.TypeDate);
    public static final MySQLType[] subTypes = new MySQLType[]{MySQLType.TypeDate};

    private DateType(MySQLType tp) {
        super(tp);
    }

    DateType(TiColumnInfo.InternalTypeHolder holder) {
        super(holder);
    }

    @Override
    public DateTimeZone getTimezone() {
        return Converter.getLocalTimezone();
    }

    @Override
    public Date getOriginDefaultValueNonNull(String value, long version) {
        return Converter.convertToDate(value);
    }

    @Override
    protected Object doConvertToTiDBType(Object value) throws ConvertNotSupportException, ConvertOverflowException {
        return this.convertToMysqlDate(value);
    }

    private Date convertToMysqlDate(Object value) throws ConvertNotSupportException {
        Date result;
        if (value instanceof Long) {
            result = new Date((Long)value);
        } else if (value instanceof String) {
            result = Date.valueOf((String)value);
        } else if (value instanceof Date) {
            result = (Date)value;
        } else if (value instanceof Timestamp) {
            result = new Date(((Timestamp)value).getTime());
        } else {
            throw new ConvertNotSupportException(value.getClass().getName(), this.getClass().getName());
        }
        return result;
    }

    @Override
    protected void encodeKey(CodecDataOutput cdo, Object value) {
        Date dt = Converter.convertToDate(value);
        Codec.DateCodec.writeDateFully(cdo, dt, this.getTimezone());
    }

    @Override
    protected void encodeProto(CodecDataOutput cdo, Object value) {
        Date dt = Converter.convertToDate(value);
        Codec.DateCodec.writeDateProto(cdo, dt, this.getTimezone());
    }

    @Override
    public String getName() {
        return "DATE";
    }

    public int getDays(LocalDate d) {
        int days = Days.daysBetween(EPOCH, d).getDays();
        if (this.getTimezone().getOffset(0L) < 0) {
            --days;
        }
        return days;
    }

    public static int toJulianGregorianCalendar(int days) {
        int d = days;
        if (Converter.getLocalTimezone().getOffset(0L) < 0) {
            ++d;
        }
        if (d < -141426) {
            if (d < -682943) {
                d -= 2;
            } else if (d < -646419) {
                --d;
            } else if (d >= -609895) {
                if (d < -536846) {
                    ++d;
                } else if (d < -500322) {
                    d += 2;
                } else if (d < -463798) {
                    d += 3;
                } else if (d < -390749) {
                    d += 4;
                } else if (d < -354225) {
                    d += 5;
                } else if (d < -317701) {
                    d += 6;
                } else if (d < -244652) {
                    d += 7;
                } else if (d < -208128) {
                    d += 8;
                } else if (d < -171604) {
                    d += 9;
                } else if (d < -141426) {
                    d += 10;
                }
            }
        }
        if (Converter.getLocalTimezone().getOffset(0L) < 0) {
            --d;
        }
        return d;
    }

    @Override
    protected Long decodeNotNull(int flag, CodecDataInput cdi) {
        LocalDate date = this.decodeDate(flag, cdi);
        if (date == null) {
            return null;
        }
        return this.getDays(date);
    }

    @Override
    protected Date decodeNotNullForBatchWrite(int flag, CodecDataInput cdi) {
        LocalDate date = this.decodeDate(flag, cdi);
        if (date == null) {
            return null;
        }
        return new Date(date.toDate().getTime());
    }
}

