/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.txn;

import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.exception.KeyException;
import com.pingcap.tikv.exception.RegionException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.operation.KVErrorHandler;
import com.pingcap.tikv.region.AbstractRegionStoreClient;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.AbstractLockResolverClient;
import com.pingcap.tikv.txn.Lock;
import com.pingcap.tikv.txn.ResolveLockResult;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ChannelFactory;
import com.pingcap.tikv.util.TsoUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Kvrpcpb;
import org.tikv.kvproto.TikvGrpc;
import shade.com.google.protobuf.ByteString;

public class LockResolverClientV2
extends AbstractRegionStoreClient
implements AbstractLockResolverClient {
    private static final Logger logger = LoggerFactory.getLogger(LockResolverClientV2.class);
    private final ReadWriteLock readWriteLock;
    private final Map<Long, Long> resolved = new HashMap<Long, Long>();
    private final Queue<Long> recentResolved = new LinkedList<Long>();

    public LockResolverClientV2(TiConfiguration conf, TiRegion region, TikvGrpc.TikvBlockingStub blockingStub, TikvGrpc.TikvStub asyncStub, ChannelFactory channelFactory, RegionManager regionManager) {
        super(conf, region, channelFactory, blockingStub, asyncStub, regionManager);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveResolved(long txnID, long status) {
        try {
            this.readWriteLock.writeLock().lock();
            if (this.resolved.containsKey(txnID)) {
                return;
            }
            this.resolved.put(txnID, status);
            this.recentResolved.add(txnID);
            if ((long)this.recentResolved.size() > 2048L) {
                Long front = this.recentResolved.remove();
                this.resolved.remove(front);
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private Long getResolved(Long txnID) {
        try {
            this.readWriteLock.readLock().lock();
            Long l = this.resolved.get(txnID);
            return l;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    private Long getTxnStatus(BackOffer bo, Long txnID, ByteString primary) {
        Kvrpcpb.CleanupResponse resp2;
        Long status = this.getResolved(txnID);
        if (status != null) {
            return status;
        }
        while (true) {
            this.region = this.regionManager.getRegionByKey(primary);
            Supplier<Kvrpcpb.CleanupRequest> factory = () -> Kvrpcpb.CleanupRequest.newBuilder().setContext(this.region.getContext()).setKey(primary).setStartVersion(txnID).build();
            KVErrorHandler<Kvrpcpb.CleanupResponse> handler = new KVErrorHandler<Kvrpcpb.CleanupResponse>(this.regionManager, this, this, this.region, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, 0L, false);
            resp2 = this.callWithRetry(bo, TikvGrpc.getKvCleanupMethod(), factory, handler);
            status = 0L;
            if (resp2 == null) {
                logger.error("getKvCleanupMethod failed without a cause");
                this.regionManager.onRequestFail(this.region);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvCleanupMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            logger.error(String.format("unexpected cleanup err: %s, tid: %d", resp2.getError(), txnID));
            throw new KeyException(resp2.getError());
        }
        if (resp2.getCommitVersion() != 0L) {
            status = resp2.getCommitVersion();
        }
        this.saveResolved(txnID, status);
        return status;
    }

    @Override
    public String getVersion() {
        return "V2";
    }

    @Override
    public ResolveLockResult resolveLocks(BackOffer bo, long callerStartTS, List<Lock> locks, boolean forWrite) {
        if (this.doResolveLocks(bo, locks)) {
            return new ResolveLockResult(0L);
        }
        return new ResolveLockResult(10000L);
    }

    private boolean doResolveLocks(BackOffer bo, List<Lock> locks) {
        if (locks.isEmpty()) {
            return true;
        }
        ArrayList<Lock> expiredLocks = new ArrayList<Lock>();
        for (Lock lock : locks) {
            if (!TsoUtils.isExpired(lock.getTxnID(), lock.getTtl())) continue;
            expiredLocks.add(lock);
        }
        if (expiredLocks.isEmpty()) {
            return false;
        }
        HashMap<Long, Set> cleanTxns = new HashMap<Long, Set>();
        for (Lock l : expiredLocks) {
            Long status = this.getTxnStatus(bo, l.getTxnID(), l.getPrimary());
            Set cleanRegion = cleanTxns.computeIfAbsent(l.getTxnID(), k -> new HashSet());
            this.resolveLock(bo, l, status, cleanRegion);
        }
        return expiredLocks.size() == locks.size();
    }

    private void resolveLock(BackOffer bo, Lock lock, long txnStatus, Set<TiRegion.RegionVerID> cleanRegion) {
        Kvrpcpb.ResolveLockResponse resp2;
        while (true) {
            this.region = this.regionManager.getRegionByKey(lock.getKey());
            if (cleanRegion.contains(this.region.getVerID())) {
                return;
            }
            Supplier<Kvrpcpb.ResolveLockRequest> factory = txnStatus > 0L ? () -> Kvrpcpb.ResolveLockRequest.newBuilder().setContext(this.region.getContext()).setStartVersion(lock.getTxnID()).setCommitVersion(txnStatus).build() : () -> Kvrpcpb.ResolveLockRequest.newBuilder().setContext(this.region.getContext()).setStartVersion(lock.getTxnID()).build();
            KVErrorHandler<Kvrpcpb.ResolveLockResponse> handler = new KVErrorHandler<Kvrpcpb.ResolveLockResponse>(this.regionManager, this, this, this.region, resp -> resp.hasRegionError() ? resp.getRegionError() : null, resp -> resp.hasError() ? resp.getError() : null, resolveLockResult -> null, 0L, false);
            resp2 = this.callWithRetry(bo, TikvGrpc.getKvResolveLockMethod(), factory, handler);
            if (resp2 == null) {
                logger.error("getKvResolveLockMethod failed without a cause");
                this.regionManager.onRequestFail(this.region);
                bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new TiClientInternalException("getKvResolveLockMethod failed without a cause"));
                continue;
            }
            if (!resp2.hasRegionError()) break;
            bo.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, new RegionException(resp2.getRegionError()));
        }
        if (resp2.hasError()) {
            logger.error(String.format("unexpected resolveLock err: %s, lock: %s", resp2.getError(), lock));
            throw new KeyException(resp2.getError());
        }
        cleanRegion.add(this.region.getVerID());
    }
}

