/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.policy;

import com.pingcap.com.google.common.collect.ImmutableSet;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.operation.ErrorHandler;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ConcreteBackOffer;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import shade.io.grpc.Status;

public abstract class RetryPolicy<RespT> {
    private final ErrorHandler<RespT> handler;
    private final ImmutableSet<Status.Code> unrecoverableStatus = ImmutableSet.of(Status.Code.ALREADY_EXISTS, Status.Code.PERMISSION_DENIED, Status.Code.INVALID_ARGUMENT, Status.Code.NOT_FOUND, Status.Code.UNIMPLEMENTED, Status.Code.OUT_OF_RANGE, new Status.Code[]{Status.Code.UNAUTHENTICATED, Status.Code.CANCELLED});
    BackOffer backOffer = ConcreteBackOffer.newCopNextMaxBackOff();

    RetryPolicy(@Nonnull ErrorHandler<RespT> handler) {
        this.handler = handler;
    }

    private void rethrowNotRecoverableException(Exception e) throws GrpcException {
        Status status = Status.fromThrowable(e);
        if (this.unrecoverableStatus.contains((Object)status.getCode())) {
            throw new GrpcException(e);
        }
    }

    public RespT callWithRetry(Callable<RespT> proc, String methodName) throws GrpcException {
        Object result;
        while (true) {
            boolean retry;
            result = null;
            try {
                result = proc.call();
            }
            catch (Exception e) {
                this.rethrowNotRecoverableException(e);
                boolean retry2 = this.handler.handleRequestError(this.backOffer, e);
                if (retry2) continue;
            }
            if (result == null || !(retry = this.handler.handleResponseError(this.backOffer, result))) break;
        }
        return result;
    }

    public static interface Builder<T> {
        public RetryPolicy<T> create(ErrorHandler<T> var1);
    }
}

