/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.operation;

import com.pingcap.tikv.codec.KeyUtils;
import com.pingcap.tikv.event.CacheInvalidateEvent;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.KeyException;
import com.pingcap.tikv.operation.ErrorHandler;
import com.pingcap.tikv.region.RegionErrorReceiver;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.AbstractLockResolverClient;
import com.pingcap.tikv.txn.Lock;
import com.pingcap.tikv.txn.ResolveLockResult;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import java.util.Collections;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Errorpb;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;
import shade.io.grpc.Status;
import shade.io.grpc.StatusRuntimeException;

public class KVErrorHandler<RespT>
implements ErrorHandler<RespT> {
    private static final Logger logger = LoggerFactory.getLogger(KVErrorHandler.class);
    private static final int NO_LEADER_STORE_ID = 0;
    private final Function<RespT, Errorpb.Error> getRegionError;
    private final Function<RespT, Kvrpcpb.KeyError> getKeyError;
    private final Function<CacheInvalidateEvent, Void> cacheInvalidateCallBack;
    private final Function<ResolveLockResult, Object> resolveLockResultCallback;
    private final RegionManager regionManager;
    private final RegionErrorReceiver recv;
    private final AbstractLockResolverClient lockResolverClient;
    private final TiRegion ctxRegion;
    private final long callerStartTS;
    private final boolean forWrite;

    public KVErrorHandler(RegionManager regionManager, RegionErrorReceiver recv, AbstractLockResolverClient lockResolverClient, TiRegion ctxRegion, Function<RespT, Errorpb.Error> getRegionError, Function<RespT, Kvrpcpb.KeyError> getKeyError, Function<ResolveLockResult, Object> resolveLockResultCallback, long callerStartTS, boolean forWrite) {
        this.ctxRegion = ctxRegion;
        this.recv = recv;
        this.lockResolverClient = lockResolverClient;
        this.regionManager = regionManager;
        this.getRegionError = getRegionError;
        this.getKeyError = getKeyError;
        this.cacheInvalidateCallBack = regionManager != null ? regionManager.getCacheInvalidateCallback() : null;
        this.resolveLockResultCallback = resolveLockResultCallback;
        this.callerStartTS = callerStartTS;
        this.forWrite = forWrite;
    }

    private Errorpb.Error getRegionError(RespT resp) {
        if (this.getRegionError != null) {
            return this.getRegionError.apply(resp);
        }
        return null;
    }

    private void invalidateRegionStoreCache(TiRegion ctxRegion) {
        this.regionManager.invalidateRegion(ctxRegion.getId());
        this.regionManager.invalidateStore(ctxRegion.getLeader().getStoreId());
        this.notifyRegionStoreCacheInvalidate(ctxRegion.getId(), ctxRegion.getLeader().getStoreId(), CacheInvalidateEvent.CacheType.REGION_STORE);
    }

    private void notifyRegionStoreCacheInvalidate(long regionId, long storeId, CacheInvalidateEvent.CacheType type) {
        if (this.cacheInvalidateCallBack != null) {
            this.cacheInvalidateCallBack.apply(new CacheInvalidateEvent(regionId, storeId, true, true, type));
            logger.info("Accumulating cache invalidation info to driver:regionId=" + regionId + ",storeId=" + storeId + ",type=" + type.name());
        } else {
            logger.warn("Failed to send notification back to driver since CacheInvalidateCallBack is null in executor node.");
        }
    }

    private void notifyRegionCacheInvalidate(long regionId) {
        if (this.cacheInvalidateCallBack != null) {
            this.cacheInvalidateCallBack.apply(new CacheInvalidateEvent(regionId, 0L, true, false, CacheInvalidateEvent.CacheType.REGION_STORE));
            logger.info("Accumulating cache invalidation info to driver:regionId=" + regionId + ",type=" + CacheInvalidateEvent.CacheType.REGION_STORE.name());
        } else {
            logger.warn("Failed to send notification back to driver since CacheInvalidateCallBack is null in executor node.");
        }
    }

    private void notifyStoreCacheInvalidate(long storeId) {
        if (this.cacheInvalidateCallBack != null) {
            this.cacheInvalidateCallBack.apply(new CacheInvalidateEvent(0L, storeId, false, true, CacheInvalidateEvent.CacheType.REGION_STORE));
        } else {
            logger.warn("Failed to send notification back to driver since CacheInvalidateCallBack is null in executor node.");
        }
    }

    private void resolveLock(BackOffer backOffer, Lock lock) {
        if (this.lockResolverClient != null) {
            logger.warn("resolving lock");
            ResolveLockResult resolveLockResult = this.lockResolverClient.resolveLocks(backOffer, this.callerStartTS, Collections.singletonList(lock), this.forWrite);
            this.resolveLockResultCallback.apply(resolveLockResult);
            long msBeforeExpired = resolveLockResult.getMsBeforeTxnExpired();
            if (msBeforeExpired > 0L) {
                backOffer.doBackOffWithMaxSleep(BackOffFunction.BackOffFuncType.BoTxnLockFast, msBeforeExpired, new KeyException(lock.toString()));
            }
        }
    }

    @Override
    public boolean handleResponseError(BackOffer backOffer, RespT resp) {
        if (resp == null) {
            String msg = String.format("Request Failed with unknown reason for region region [%s]", this.ctxRegion);
            logger.warn(msg);
            return this.handleRequestError(backOffer, new GrpcException(msg));
        }
        Errorpb.Error error = this.getRegionError(resp);
        if (error != null) {
            if (error.hasNotLeader()) {
                BackOffFunction.BackOffFuncType backOffFuncType;
                long newStoreId = error.getNotLeader().getLeader().getStoreId();
                boolean retry = true;
                logger.warn(String.format("NotLeader Error with region id %d and store id %d, new store id %d", this.ctxRegion.getId(), this.ctxRegion.getLeader().getStoreId(), newStoreId));
                if (newStoreId != 0L) {
                    if (!this.regionManager.updateLeader(this.ctxRegion.getId(), newStoreId) || !this.recv.onNotLeader(this.regionManager.getStoreById(newStoreId))) {
                        retry = false;
                    }
                    this.notifyRegionStoreCacheInvalidate(this.ctxRegion.getId(), newStoreId, CacheInvalidateEvent.CacheType.LEADER);
                    backOffFuncType = BackOffFunction.BackOffFuncType.BoUpdateLeader;
                } else {
                    logger.info(String.format("Received zero store id, from region %d try next time", this.ctxRegion.getId()));
                    backOffFuncType = BackOffFunction.BackOffFuncType.BoRegionMiss;
                }
                backOffer.doBackOff(backOffFuncType, new GrpcException(error.toString()));
                return retry;
            }
            if (error.hasStoreNotMatch()) {
                long storeId = this.ctxRegion.getLeader().getStoreId();
                logger.warn(String.format("Store Not Match happened with region id %d, store id %d", this.ctxRegion.getId(), storeId));
                this.regionManager.invalidateStore(storeId);
                this.recv.onStoreNotMatch(this.regionManager.getStoreById(storeId));
                this.notifyStoreCacheInvalidate(storeId);
                return true;
            }
            if (error.hasEpochNotMatch()) {
                logger.warn(String.format("Stale Epoch encountered for region [%s]", this.ctxRegion));
                this.regionManager.onRegionStale(this.ctxRegion.getId());
                this.notifyRegionCacheInvalidate(this.ctxRegion.getId());
                return false;
            }
            if (error.hasServerIsBusy()) {
                logger.warn(String.format("Server is busy for region [%s], reason: %s", this.ctxRegion, error.getServerIsBusy().getReason()));
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoServerBusy, new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString())));
                return true;
            }
            if (error.hasStaleCommand()) {
                logger.warn(String.format("Stale command for region [%s]", this.ctxRegion));
                return true;
            }
            if (error.hasRaftEntryTooLarge()) {
                logger.warn(String.format("Raft too large for region [%s]", this.ctxRegion));
                throw new StatusRuntimeException(Status.fromCode(Status.Code.UNAVAILABLE).withDescription(error.toString()));
            }
            if (error.hasKeyNotInRegion()) {
                ByteString invalidKey = error.getKeyNotInRegion().getKey();
                logger.error(String.format("Key not in region [%s] for key [%s], this error should not happen here.", this.ctxRegion, KeyUtils.formatBytesUTF8(invalidKey)));
                throw new StatusRuntimeException(Status.UNKNOWN.withDescription(error.toString()));
            }
            logger.warn(String.format("Unknown error %s for region [%s]", error.toString(), this.ctxRegion));
            this.invalidateRegionStoreCache(this.ctxRegion);
        }
        boolean retry = false;
        Kvrpcpb.KeyError keyError = this.getKeyError.apply(resp);
        if (keyError != null) {
            try {
                Lock lock = AbstractLockResolverClient.extractLockFromKeyErr(keyError);
                this.resolveLock(backOffer, lock);
                retry = true;
            }
            catch (KeyException e) {
                logger.warn("Unable to handle KeyExceptions other than LockException", (Throwable)e);
            }
        }
        return retry;
    }

    @Override
    public boolean handleRequestError(BackOffer backOffer, Exception e) {
        this.regionManager.onRequestFail(this.ctxRegion);
        this.notifyRegionStoreCacheInvalidate(this.ctxRegion.getId(), this.ctxRegion.getLeader().getStoreId(), CacheInvalidateEvent.CacheType.REQ_FAILED);
        backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoTiKVRPC, new GrpcException("send tikv request error: " + e.getMessage() + ", try next peer later", e));
        return false;
    }
}

