/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.expression;

import com.pingcap.com.google.common.collect.ImmutableList;
import com.pingcap.tikv.expression.Expression;
import com.pingcap.tikv.expression.Visitor;
import com.pingcap.tikv.types.DataType;
import java.util.List;
import java.util.Objects;

public class ArithmeticBinaryExpression
extends Expression {
    private final Expression left;
    private final Expression right;
    private final Type compType;

    public ArithmeticBinaryExpression(DataType dataType, Type type, Expression left, Expression right) {
        super(dataType);
        this.resolved = true;
        this.left = Objects.requireNonNull(left, "left expression is null");
        this.right = Objects.requireNonNull(right, "right expression is null");
        this.compType = Objects.requireNonNull(type, "type is null");
    }

    public static ArithmeticBinaryExpression plus(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.PLUS, left, right);
    }

    public static ArithmeticBinaryExpression minus(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.MINUS, left, right);
    }

    public static ArithmeticBinaryExpression multiply(DataType dataType, Expression left, Expression right) {
        return new ArithmeticBinaryExpression(dataType, Type.MULTIPLY, left, right);
    }

    public static ArithmeticBinaryExpression multiply(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.MULTIPLY, left, right);
    }

    public static ArithmeticBinaryExpression divide(DataType dataType, Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.DIVIDE, left, right);
    }

    public static ArithmeticBinaryExpression divide(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.DIVIDE, left, right);
    }

    public static ArithmeticBinaryExpression bitAnd(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.BIT_AND, left, right);
    }

    public static ArithmeticBinaryExpression bitOr(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.BIT_OR, left, right);
    }

    public static ArithmeticBinaryExpression bitXor(Expression left, Expression right) {
        return new ArithmeticBinaryExpression(left.dataType, Type.BIT_XOR, left, right);
    }

    public Expression getLeft() {
        return this.left;
    }

    public Expression getRight() {
        return this.right;
    }

    public Type getCompType() {
        return this.compType;
    }

    @Override
    public List<Expression> getChildren() {
        return ImmutableList.of(this.left, this.right);
    }

    @Override
    public <R, C> R accept(Visitor<R, C> visitor, C context) {
        return visitor.visit(this, context);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArithmeticBinaryExpression)) {
            return false;
        }
        ArithmeticBinaryExpression that = (ArithmeticBinaryExpression)other;
        return this.compType == that.compType && Objects.equals(this.left, that.left) && Objects.equals(this.right, that.right);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.compType, this.left, this.right});
    }

    public String toString() {
        return String.format("[%s %s %s]", new Object[]{this.getLeft(), this.getCompType(), this.getRight()});
    }

    public static enum Type {
        PLUS,
        MINUS,
        MULTIPLY,
        DIVIDE,
        BIT_AND,
        BIT_OR,
        BIT_XOR;

    }
}

