/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.columnar;

public class TiCoreTime {
    private static final long YEAR_BIT_FIELD_OFFSET = 50L;
    private static final long YEAR_BIT_FIELD_WIDTH = 14L;
    private static final long MONTH_BIT_FIELD_OFFSET = 46L;
    private static final long MONTH_BIT_FIELD_WIDTH = 4L;
    private static final long DAY_BIT_FIELD_OFFSET = 41L;
    private static final long DAY_BIT_FIELD_WIDTH = 5L;
    private static final long HOUR_BIT_FIELD_OFFSET = 36L;
    private static final long HOUR_BIT_FIELD_WIDTH = 5L;
    private static final long MINUTE_BIT_FIELD_OFFSET = 30L;
    private static final long MINUTE_BIT_FIELD_WIDTH = 6L;
    private static final long SECOND_BIT_FIELD_OFFSET = 24L;
    private static final long SECOND_BIT_FIELD_WIDTH = 6L;
    private static final long MICROSECOND_BIT_FIELD_OFFSET = 4L;
    private static final long MICROSECOND_BIT_FIELD_WIDTH = 20L;
    private static final long YEAR_BIT_FIELD_MASK = -1125899906842624L;
    private static final long MONTH_BIT_FIELD_MASK = 0x3C00000000000L;
    private static final long DAY_BIT_FIELD_MASK = 0x3E0000000000L;
    private static final long HOUR_BIT_FIELD_MASK = 0x1F000000000L;
    private static final long MINUTE_BIT_FIELD_MASK = 0xFC0000000L;
    private static final long SECOND_BIT_FIELD_MASK = 0x3F000000L;
    private static final long MICROSECOND_BIT_FIELD_MASK = 0xFFFFF0L;
    private final long coreTime;

    public TiCoreTime(long coreTime) {
        this.coreTime = coreTime;
    }

    public int getYear() {
        return (int)((this.coreTime & 0xFFFC000000000000L) >>> 50);
    }

    public int getMonth() {
        return (int)((this.coreTime & 0x3C00000000000L) >>> 46);
    }

    public int getDay() {
        return (int)((this.coreTime & 0x3E0000000000L) >>> 41);
    }

    public int getHour() {
        return (int)((this.coreTime & 0x1F000000000L) >>> 36);
    }

    public int getMinute() {
        return (int)((this.coreTime & 0xFC0000000L) >>> 30);
    }

    public int getSecond() {
        return (int)((this.coreTime & 0x3F000000L) >>> 24);
    }

    public long getMicroSecond() {
        return (this.coreTime & 0xFFFFF0L) >>> 4;
    }
}

