/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv.columnar;

import com.pingcap.tikv.columnar.TiColumnVector;
import com.pingcap.tikv.datatype.TypeMapping;
import java.math.BigDecimal;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.vectorized.ColumnVector;
import org.apache.spark.sql.vectorized.ColumnarArray;
import org.apache.spark.sql.vectorized.ColumnarMap;
import org.apache.spark.unsafe.types.UTF8String;

public class TiColumnVectorAdapter
extends ColumnVector {
    private final TiColumnVector tiColumnVector;

    public TiColumnVectorAdapter(TiColumnVector tiColumnVector) {
        super(TypeMapping.toSparkType(tiColumnVector.dataType()));
        this.tiColumnVector = tiColumnVector;
    }

    public void close() {
    }

    public boolean hasNull() {
        return this.tiColumnVector.hasNull();
    }

    public int numNulls() {
        return this.tiColumnVector.numNulls();
    }

    public boolean isNullAt(int rowId) {
        return this.tiColumnVector.isNullAt(rowId);
    }

    public boolean getBoolean(int rowId) {
        return this.tiColumnVector.getBoolean(rowId);
    }

    public byte getByte(int rowId) {
        return this.tiColumnVector.getByte(rowId);
    }

    public short getShort(int rowId) {
        return this.tiColumnVector.getShort(rowId);
    }

    public int getInt(int rowId) {
        return this.tiColumnVector.getInt(rowId);
    }

    public long getLong(int rowId) {
        return this.tiColumnVector.getLong(rowId);
    }

    public float getFloat(int rowId) {
        return this.tiColumnVector.getFloat(rowId);
    }

    public double getDouble(int rowId) {
        return this.tiColumnVector.getDouble(rowId);
    }

    public ColumnarArray getArray(int rowId) {
        throw new UnsupportedOperationException("TiColumnVectorAdapter is not supported this method");
    }

    public ColumnarMap getMap(int ordinal) {
        throw new UnsupportedOperationException("TiColumnVectorAdapter is not supported this method");
    }

    public Decimal getDecimal(int rowId, int precision, int scale) {
        return Decimal.apply((BigDecimal)this.tiColumnVector.getDecimal(rowId, precision, scale));
    }

    public UTF8String getUTF8String(int rowId) {
        return UTF8String.fromString((String)this.tiColumnVector.getUTF8String(rowId));
    }

    public byte[] getBinary(int rowId) {
        return this.tiColumnVector.getBinary(rowId);
    }

    protected ColumnVector getChild(int ordinal) {
        throw new UnsupportedOperationException("TiColumnVectorAdapter is not supported this method");
    }
}

