/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.tikv.exception.TiBatchWriteException;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.type.GroupKeyResult;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class Utils {
    public static GroupKeyResult groupKeysByRegion(RegionManager regionManager, List<ByteString> keys, BackOffer backOffer) {
        return Utils.groupKeysByRegion(regionManager, keys.toArray(new ByteString[0]), keys.size(), backOffer);
    }

    public static GroupKeyResult groupKeysByRegion(RegionManager regionManager, ByteString[] keys, int size, BackOffer backOffer) throws TiBatchWriteException {
        HashMap<Pair<TiRegion, Metapb.Store>, List<ByteString>> groups = new HashMap<Pair<TiRegion, Metapb.Store>, List<ByteString>>();
        try {
            for (int index = 0; index < size; ++index) {
                ByteString key = keys[index];
                Pair<TiRegion, Metapb.Store> pair = regionManager.getRegionStorePairByKey(key, backOffer);
                if (pair == null) continue;
                groups.computeIfAbsent(pair, e -> new ArrayList()).add(key);
            }
        }
        catch (Exception e2) {
            throw new TiBatchWriteException("Txn groupKeysByRegion error", e2);
        }
        GroupKeyResult result = new GroupKeyResult();
        result.setGroupsResult(groups);
        return result;
    }
}

