/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pingcap.tikv.PDClient;
import com.pingcap.tikv.Snapshot;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.catalog.Catalog;
import com.pingcap.tikv.event.CacheInvalidateEvent;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.exception.TiKVException;
import com.pingcap.tikv.key.Key;
import com.pingcap.tikv.meta.TiTimestamp;
import com.pingcap.tikv.region.RegionManager;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.txn.TxnKVClient;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ChannelFactory;
import com.pingcap.tikv.util.ConcreteBackOffer;
import com.pingcap.tikv.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Metapb;
import shade.com.google.protobuf.ByteString;

public class TiSession
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(TiSession.class);
    private static final Map<String, TiSession> sessionCachedMap = new HashMap<String, TiSession>();
    private final TiConfiguration conf;
    private final ChannelFactory channelFactory;
    private Function<CacheInvalidateEvent, Void> cacheInvalidateCallback;
    private volatile PDClient client;
    private volatile Catalog catalog;
    private volatile ExecutorService indexScanThreadPool;
    private volatile ExecutorService tableScanThreadPool;
    private volatile RegionManager regionManager;
    private volatile RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private boolean isClosed = false;

    private TiSession(TiConfiguration conf) {
        this.conf = conf;
        this.channelFactory = new ChannelFactory(conf.getMaxFrameSize());
        this.regionManager = null;
        this.clientBuilder = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TiSession getInstance(TiConfiguration conf) {
        Map<String, TiSession> map = sessionCachedMap;
        synchronized (map) {
            String key = conf.getPdAddrsString();
            if (sessionCachedMap.containsKey(key)) {
                return sessionCachedMap.get(key);
            }
            TiSession newSession = new TiSession(conf);
            sessionCachedMap.put(key, newSession);
            return newSession;
        }
    }

    public TxnKVClient createTxnClient() {
        return new TxnKVClient(this.conf, this.getRegionStoreClientBuilder(), this.getPDClient());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionStoreClient.RegionStoreClientBuilder getRegionStoreClientBuilder() {
        RegionStoreClient.RegionStoreClientBuilder res = this.clientBuilder;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.clientBuilder == null) {
                    this.clientBuilder = new RegionStoreClient.RegionStoreClientBuilder(this.conf, this.channelFactory, this.getRegionManager(), this.getPDClient());
                }
                res = this.clientBuilder;
            }
        }
        return res;
    }

    public TiConfiguration getConf() {
        return this.conf;
    }

    public TiTimestamp getTimestamp() {
        return this.getPDClient().getTimestamp(ConcreteBackOffer.newTsoBackOff());
    }

    public Snapshot createSnapshot() {
        return new Snapshot(this.getTimestamp(), this.conf);
    }

    public Snapshot createSnapshot(TiTimestamp ts) {
        return new Snapshot(ts, this.conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PDClient getPDClient() {
        PDClient res = this.client;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.client == null) {
                    this.client = PDClient.createRaw(this.getConf(), this.channelFactory);
                }
                res = this.client;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Catalog getCatalog() {
        Catalog res = this.catalog;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.catalog == null) {
                    this.catalog = new Catalog(this::createSnapshot, this.conf.ifShowRowId(), this.conf.getDBPrefix());
                }
                res = this.catalog;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RegionManager getRegionManager() {
        RegionManager res = this.regionManager;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.regionManager == null) {
                    this.regionManager = new RegionManager(this.getPDClient(), this.cacheInvalidateCallback);
                }
                res = this.regionManager;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForIndexScan() {
        ExecutorService res = this.indexScanThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.indexScanThreadPool == null) {
                    this.indexScanThreadPool = Executors.newFixedThreadPool(this.conf.getIndexScanConcurrency(), new ThreadFactoryBuilder().setNameFormat("index-scan-pool-%d").setDaemon(true).build());
                }
                res = this.indexScanThreadPool;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExecutorService getThreadPoolForTableScan() {
        ExecutorService res = this.tableScanThreadPool;
        if (res == null) {
            TiSession tiSession = this;
            synchronized (tiSession) {
                if (this.tableScanThreadPool == null) {
                    this.tableScanThreadPool = Executors.newFixedThreadPool(this.conf.getTableScanConcurrency(), new ThreadFactoryBuilder().setDaemon(true).build());
                }
                res = this.tableScanThreadPool;
            }
        }
        return res;
    }

    public void injectCallBackFunc(Function<CacheInvalidateEvent, Void> callBackFunc) {
        this.cacheInvalidateCallback = callBackFunc;
    }

    public void splitRegionAndScatter(List<byte[]> splitKeys, int splitRegionBackoffMS, int scatterRegionBackoffMS, int scatterWaitMS) {
        logger.info(String.format("split key's size is %d", splitKeys.size()));
        long startMS = System.currentTimeMillis();
        List<TiRegion> newRegions = this.splitRegion(splitKeys.stream().map(k -> Key.toRawKey(k).next().toByteString()).collect(Collectors.toList()), ConcreteBackOffer.newCustomBackOff(splitRegionBackoffMS));
        for (TiRegion newRegion : newRegions) {
            try {
                this.getPDClient().scatterRegion(newRegion, ConcreteBackOffer.newCustomBackOff(scatterRegionBackoffMS));
            }
            catch (Exception e) {
                logger.warn(String.format("failed to scatter region: %d", newRegion.getId()), (Throwable)e);
            }
        }
        if (scatterWaitMS > 0) {
            logger.info("start to wait scatter region finish");
            long scatterRegionStartMS = System.currentTimeMillis();
            for (TiRegion newRegion : newRegions) {
                long remainMS = scatterRegionStartMS + (long)scatterWaitMS - System.currentTimeMillis();
                if (remainMS <= 0L) {
                    logger.warn("wait scatter region timeout");
                    return;
                }
                this.getPDClient().waitScatterRegionFinish(newRegion, ConcreteBackOffer.newCustomBackOff((int)remainMS));
            }
        } else {
            logger.info("skip to wait scatter region finish");
        }
        long endMS = System.currentTimeMillis();
        logger.info("splitRegionAndScatter cost {} seconds", (Object)((endMS - startMS) / 1000L));
    }

    private List<TiRegion> splitRegion(List<ByteString> splitKeys, BackOffer backOffer) {
        ArrayList<TiRegion> regions = new ArrayList<TiRegion>();
        Map<TiRegion, List<ByteString>> groupKeys = this.groupKeysByRegion(splitKeys);
        for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
            List<TiRegion> newRegions;
            Pair<TiRegion, Metapb.Store> pair = this.getRegionManager().getRegionStorePairByKey(entry.getKey().getStartKey());
            TiRegion region = (TiRegion)pair.first;
            Metapb.Store store = (Metapb.Store)pair.second;
            List<ByteString> splits = entry.getValue().stream().filter(k -> !k.equals(region.getStartKey()) && !k.equals(region.getEndKey())).collect(Collectors.toList());
            if (splits.isEmpty()) {
                logger.warn("split key equal to region start key or end key. Region splitting is not needed.");
                continue;
            }
            logger.info("start to split region id={}, split size={}", (Object)region.getId(), (Object)splits.size());
            try {
                newRegions = this.getRegionStoreClientBuilder().build(region, store).splitRegion(splits);
            }
            catch (TiClientInternalException | TiKVException e) {
                logger.warn("ReSplitting ranges for splitRegion", (Throwable)e);
                this.clientBuilder.getRegionManager().invalidateRegion(region.getId());
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                newRegions = this.splitRegion(splits, backOffer);
            }
            logger.info("region id={}, new region size={}", (Object)region.getId(), (Object)newRegions.size());
            regions.addAll(newRegions);
        }
        logger.info("splitRegion: return region size={}", (Object)regions.size());
        return regions;
    }

    private Map<TiRegion, List<ByteString>> groupKeysByRegion(List<ByteString> keys) {
        return keys.stream().collect(Collectors.groupingBy(this.clientBuilder.getRegionManager()::getRegionByKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws Exception {
        if (this.isClosed) {
            logger.warn("this TiSession is already closed!");
            return;
        }
        this.isClosed = true;
        Map<String, TiSession> map = sessionCachedMap;
        synchronized (map) {
            sessionCachedMap.remove(this.conf.getPdAddrsString());
        }
        if (this.tableScanThreadPool != null) {
            this.tableScanThreadPool.shutdownNow();
        }
        if (this.indexScanThreadPool != null) {
            this.indexScanThreadPool.shutdownNow();
        }
        if (this.client != null) {
            this.getPDClient().close();
        }
        if (this.catalog != null) {
            this.getCatalog().close();
        }
    }
}

