/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TiDBJDBCClient
implements AutoCloseable {
    private static final String UNLOCK_TABLES_SQL = "unlock tables";
    private static final String SELECT_TIDB_CONFIG_SQL = "select @@tidb_config";
    private static final String ENABLE_TABLE_LOCK_KEY = "enable-table-lock";
    private static final Boolean ENABLE_TABLE_LOCK_DEFAULT = false;
    private static final String DELAY_CLEAN_TABLE_LOCK = "delay-clean-table-lock";
    private static final int DELAY_CLEAN_TABLE_LOCK_DEFAULT = 0;
    private static final String TIDB_ROW_FORMAT_VERSION_SQL = "select @@tidb_row_format_version";
    private static final int TIDB_ROW_FORMAT_VERSION_DEFAULT = 1;
    private static final String ALTER_PRIMARY_KEY_KEY = "alter-primary-key";
    private static final Boolean ALTER_PRIMARY_KEY_DEFAULT = false;
    private final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    private final Connection connection;

    public TiDBJDBCClient(Connection connection) {
        this.connection = connection;
    }

    public boolean isEnableAlterPrimaryKey() throws IOException, SQLException {
        Map<String, Object> configMap = this.readConfMapFromTiDB();
        return (Boolean)configMap.getOrDefault(ALTER_PRIMARY_KEY_KEY, ALTER_PRIMARY_KEY_DEFAULT);
    }

    public boolean isEnableTableLock() throws IOException, SQLException {
        Map<String, Object> configMap = this.readConfMapFromTiDB();
        Object enableTableLock = configMap.getOrDefault(ENABLE_TABLE_LOCK_KEY, ENABLE_TABLE_LOCK_DEFAULT);
        return (Boolean)enableTableLock;
    }

    public boolean supportClusteredIndex() throws IOException, SQLException {
        try {
            this.queryTiDBViaJDBC("select @@tidb_enable_clustered_index");
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    public int getDelayCleanTableLock() throws IOException, SQLException {
        Map<String, Object> configMap = this.readConfMapFromTiDB();
        Object enableTableLock = configMap.getOrDefault(DELAY_CLEAN_TABLE_LOCK, 0);
        return (Integer)enableTableLock;
    }

    public int getRowFormatVersion() {
        try {
            List<List<Object>> result = this.queryTiDBViaJDBC(TIDB_ROW_FORMAT_VERSION_SQL);
            if (result.isEmpty()) {
                return 1;
            }
            Object version = result.get(0).get(0);
            if (version instanceof String) {
                return Integer.parseInt((String)version);
            }
            if (version instanceof Number) {
                return ((Number)version).intValue();
            }
            return 1;
        }
        catch (Exception ignored) {
            return 1;
        }
    }

    public boolean lockTableWriteLocal(String databaseName, String tableName) throws SQLException {
        try (Statement tidbStmt = this.connection.createStatement();){
            String sql = "lock tables `" + databaseName + "`.`" + tableName + "` write local";
            int result = tidbStmt.executeUpdate(sql);
            boolean bl = result == 0;
            return bl;
        }
    }

    public boolean unlockTables() throws SQLException {
        try (Statement tidbStmt = this.connection.createStatement();){
            int result = tidbStmt.executeUpdate(UNLOCK_TABLES_SQL);
            boolean bl = result == 0;
            return bl;
        }
    }

    public boolean dropTable(String databaseName, String tableName) throws SQLException {
        try (Statement tidbStmt = this.connection.createStatement();){
            String sql = "drop table if exists `" + databaseName + "`.`" + tableName + "`";
            boolean bl = tidbStmt.execute(sql);
            return bl;
        }
    }

    public void updateTableStatistics(long startTS, long tableId, long delta, long count) throws SQLException {
        try (Statement tidbStmt = this.connection.createStatement();){
            String sql = delta < 0L ? String.format("update mysql.stats_meta set version = %s, count = count - %s, modify_count = modify_count + %s where table_id = %s and count >= %s", startTS, -delta, count, tableId, -delta) : String.format("update mysql.stats_meta set version = %s, count = count + %s, modify_count = modify_count + %s where table_id = %s", startTS, delta, count, tableId);
            this.logger.info("updateTableStatistics: " + sql);
            tidbStmt.executeUpdate(sql);
        }
    }

    private Map<String, Object> readConfMapFromTiDB() throws SQLException, IOException {
        String configJSON = (String)this.queryTiDBViaJDBC(SELECT_TIDB_CONFIG_SQL).get(0).get(0);
        ObjectMapper objectMapper = new ObjectMapper();
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (Map)objectMapper.readValue(configJSON, (TypeReference)typeRef);
    }

    public boolean isClosed() throws SQLException {
        return this.connection.isClosed();
    }

    @Override
    public void close() throws Exception {
        this.connection.close();
    }

    private List<List<Object>> queryTiDBViaJDBC(String query) throws SQLException {
        ArrayList<List<Object>> result = new ArrayList<List<Object>>();
        try (Statement tidbStmt = this.connection.createStatement();){
            ResultSet resultSet = tidbStmt.executeQuery(query);
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            while (resultSet.next()) {
                ArrayList<Object> row = new ArrayList<Object>();
                for (int i = 1; i <= rsMetaData.getColumnCount(); ++i) {
                    row.add(resultSet.getObject(i));
                }
                result.add(row);
            }
        }
        return result;
    }
}

