/*
 * Decompiled with CFR 0.152.
 */
package com.pingcap.tikv;

import com.pingcap.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.pingcap.tikv.TiConfiguration;
import com.pingcap.tikv.exception.GrpcException;
import com.pingcap.tikv.exception.TiClientInternalException;
import com.pingcap.tikv.exception.TiKVException;
import com.pingcap.tikv.operation.iterator.ConcreteScanIterator;
import com.pingcap.tikv.region.RegionStoreClient;
import com.pingcap.tikv.region.TiRegion;
import com.pingcap.tikv.util.BackOffFunction;
import com.pingcap.tikv.util.BackOffer;
import com.pingcap.tikv.util.ConcreteBackOffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tikv.kvproto.Kvrpcpb;
import shade.com.google.protobuf.ByteString;

public class KVClient
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(KVClient.class);
    private static final int BATCH_GET_SIZE = 16384;
    private final RegionStoreClient.RegionStoreClientBuilder clientBuilder;
    private final TiConfiguration conf;
    private final ExecutorService executorService;

    public KVClient(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder clientBuilder) {
        Objects.requireNonNull(conf, "conf is null");
        Objects.requireNonNull(clientBuilder, "clientBuilder is null");
        this.conf = conf;
        this.clientBuilder = clientBuilder;
        this.executorService = Executors.newFixedThreadPool(conf.getKvClientConcurrency(), new ThreadFactoryBuilder().setNameFormat("kvclient-pool-%d").setDaemon(true).build());
    }

    @Override
    public void close() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
        }
    }

    public ByteString get(ByteString key, long version) throws GrpcException {
        ConcreteBackOffer backOffer = ConcreteBackOffer.newGetBackOff();
        while (true) {
            RegionStoreClient client = this.clientBuilder.build(key);
            try {
                return client.get(backOffer, key, version);
            }
            catch (TiClientInternalException | TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                continue;
            }
            break;
        }
    }

    public List<Kvrpcpb.KvPair> batchGet(BackOffer backOffer, List<ByteString> keys, long version) throws GrpcException {
        return this.doSendBatchGet(backOffer, keys, version);
    }

    public List<Kvrpcpb.KvPair> scan(ByteString startKey, ByteString endKey, long version) throws GrpcException {
        Iterator<Kvrpcpb.KvPair> iterator = this.scanIterator(this.conf, this.clientBuilder, startKey, endKey, version);
        ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
        iterator.forEachRemaining(result::add);
        return result;
    }

    public List<Kvrpcpb.KvPair> scan(ByteString startKey, long version, int limit) throws GrpcException {
        Iterator<Kvrpcpb.KvPair> iterator = this.scanIterator(this.conf, this.clientBuilder, startKey, version, limit);
        ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
        iterator.forEachRemaining(result::add);
        return result;
    }

    public List<Kvrpcpb.KvPair> scan(ByteString startKey, long version) throws GrpcException {
        return this.scan(startKey, version, Integer.MAX_VALUE);
    }

    private List<Kvrpcpb.KvPair> doSendBatchGet(BackOffer backOffer, List<ByteString> keys, long version) {
        ExecutorCompletionService<List> completionService = new ExecutorCompletionService<List>(this.executorService);
        Map<TiRegion, List<ByteString>> groupKeys = this.groupKeysByRegion(keys);
        ArrayList<Batch> batches = new ArrayList<Batch>();
        for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
            this.appendBatches(batches, entry.getKey(), entry.getValue(), 16384);
        }
        for (Batch batch : batches) {
            ConcreteBackOffer singleBatchBackOffer = ConcreteBackOffer.create(backOffer);
            completionService.submit(() -> this.doSendBatchGetInBatchesWithRetry(singleBatchBackOffer, batch, version));
        }
        try {
            ArrayList<Kvrpcpb.KvPair> result = new ArrayList<Kvrpcpb.KvPair>();
            for (int i = 0; i < batches.size(); ++i) {
                result.addAll((Collection)completionService.take().get());
            }
            return result;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new TiKVException("Current thread interrupted.", e);
        }
        catch (ExecutionException e) {
            throw new TiKVException("Execution exception met.", e);
        }
    }

    private List<Kvrpcpb.KvPair> doSendBatchGetInBatchesWithRetry(BackOffer backOffer, Batch batch, long version) {
        TiRegion currentRegion;
        TiRegion oldRegion = batch.region;
        if (oldRegion.equals(currentRegion = this.clientBuilder.getRegionManager().getRegionByKey(oldRegion.getStartKey()))) {
            RegionStoreClient client = this.clientBuilder.build(batch.region);
            try {
                return client.batchGet(backOffer, batch.keys, version);
            }
            catch (TiClientInternalException | TiKVException e) {
                backOffer.doBackOff(BackOffFunction.BackOffFuncType.BoRegionMiss, e);
                this.clientBuilder.getRegionManager().invalidateRegion(batch.region.getId());
                logger.warn("ReSplitting ranges for BatchGetRequest", (Throwable)e);
                return this.doSendBatchGetWithRefetchRegion(backOffer, batch, version);
            }
        }
        return this.doSendBatchGetWithRefetchRegion(backOffer, batch, version);
    }

    private List<Kvrpcpb.KvPair> doSendBatchGetWithRefetchRegion(BackOffer backOffer, Batch batch, long version) {
        Map<TiRegion, List<ByteString>> groupKeys = this.groupKeysByRegion(batch.keys);
        ArrayList<Batch> retryBatches = new ArrayList<Batch>();
        for (Map.Entry<TiRegion, List<ByteString>> entry : groupKeys.entrySet()) {
            this.appendBatches(retryBatches, entry.getKey(), entry.getValue(), 16384);
        }
        ArrayList<Kvrpcpb.KvPair> results = new ArrayList<Kvrpcpb.KvPair>();
        for (Batch retryBatch : retryBatches) {
            List<Kvrpcpb.KvPair> batchResult = this.doSendBatchGetInBatchesWithRetry(backOffer, retryBatch, version);
            results.addAll(batchResult);
        }
        return results;
    }

    private void appendBatches(List<Batch> batches, TiRegion region, List<ByteString> keys, int batchGetMaxSizeInByte) {
        if (keys == null) {
            return;
        }
        int len = keys.size();
        int start = 0;
        while (start < len) {
            int end;
            int size = 0;
            for (end = start; end < len && size < batchGetMaxSizeInByte; size += keys.get(end).size(), ++end) {
            }
            Batch batch = new Batch(region, keys.subList(start, end));
            batches.add(batch);
            start = end;
        }
    }

    private Map<TiRegion, List<ByteString>> groupKeysByRegion(List<ByteString> keys) {
        return keys.stream().collect(Collectors.groupingBy(this.clientBuilder.getRegionManager()::getRegionByKey));
    }

    private Iterator<Kvrpcpb.KvPair> scanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, ByteString endKey, long version) {
        return new ConcreteScanIterator(conf, builder, startKey, endKey, version);
    }

    private Iterator<Kvrpcpb.KvPair> scanIterator(TiConfiguration conf, RegionStoreClient.RegionStoreClientBuilder builder, ByteString startKey, long version, int limit) {
        return new ConcreteScanIterator(conf, builder, startKey, version, limit);
    }

    private static final class Batch {
        private final TiRegion region;
        private final List<ByteString> keys;

        Batch(TiRegion region, List<ByteString> keys) {
            this.region = region;
            this.keys = keys;
        }
    }
}

