/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.dione.avro.hadoop.file;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public class RecordProjection {
    private final Schema keySchema;
    private final Schema valueSchema;

    public RecordProjection(Schema keySchema, Schema valueSchema) {
        this.keySchema = keySchema;
        this.valueSchema = valueSchema;
    }

    public GenericRecord getKey(GenericRecord record) {
        return this.projectSchema(record, this.keySchema);
    }

    public GenericRecord getValue(GenericRecord record) {
        Schema schema = this.valueSchema;
        return this.projectSchema(record, schema);
    }

    public Long getMetadata(GenericRecord record) {
        GenericData.Record res = new GenericData.Record(this.keySchema);
        return (Long)record.get("metadata");
    }

    private GenericRecord projectSchema(GenericRecord record, Schema schema) {
        GenericData.Record res = new GenericData.Record(schema);
        schema.getFields().stream().map(Schema.Field::name).forEach(f -> res.put(f, record.get(f)));
        return res;
    }
}

