/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.dione.avro.hadoop.file;

import com.paypal.dione.avro.hadoop.file.RecordProjection;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.file.SeekableByteArrayInput;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.specific.SpecificData;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroBtreeFile {
    public static final String DATA_SIZE_KEY = "data_bytes";
    public static final String METADATA_COL_NAME = "metadata";
    public static final String KEY_VALUE_HEADER_NAME = "btree.spec.kv";
    private static final Logger logger = LoggerFactory.getLogger(AvroBtreeFile.class);
    public static Schema metadataSchema = (Schema)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.UnionAccumulator)SchemaBuilder.unionOf().nullType()).and().longType()).endUnion();

    public static Schema createSchema(Schema key, Schema value) {
        ArrayList<Schema.Field> schemaFields = new ArrayList<Schema.Field>();
        AvroBtreeFile.addFromSchema(schemaFields, key);
        AvroBtreeFile.addFromSchema(schemaFields, value);
        schemaFields.add(new Schema.Field(METADATA_COL_NAME, metadataSchema, metadataSchema.getDoc(), null, Schema.Field.Order.ASCENDING));
        Schema schema = Schema.createRecord((String)"keyValueSchema", (String)"doc", (String)"na", (boolean)false);
        schema.setFields(schemaFields);
        return schema;
    }

    private static void addFromSchema(List<Schema.Field> schemaFields, Schema srcSchema) {
        srcSchema.getFields().stream().forEach(field -> {
            Schema.Field f = new Schema.Field(field.name(), field.schema(), field.doc(), field.defaultVal(), field.order());
            schemaFields.add(f);
        });
    }

    private static Schema projectSchema(Schema schema, String[] fields) {
        if (fields.length == 0) {
            throw new RuntimeException("attempt to create empty schema");
        }
        HashMap map = new HashMap();
        schema.getFields().forEach(f -> map.put(f.name(), f));
        List schemaFields = Arrays.stream(fields).map(map::get).filter(Objects::nonNull).map(AvroBtreeFile::cloneField).collect(Collectors.toList());
        if (schemaFields.size() != fields.length) {
            throw new RuntimeException("fields are not subset of the schema");
        }
        return Schema.createRecord(schemaFields);
    }

    private static Schema.Field cloneField(Schema.Field f) {
        return new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order());
    }

    public static class BufferedWriter {
        private final Schema schema;
        private final ByteArrayOutputStream recordsBuffer;
        private final DataFileWriter<GenericRecord> memoryWriter;
        private final Writer.Options options;
        private final LinkedList<Long> syncs;
        private final String keyValueFields;
        private final long headerPosition;

        public BufferedWriter(Writer.Options options, Schema schema, String keyValueFields) throws IOException {
            ByteArrayOutputStream recordsBuffer = new ByteArrayOutputStream(options.initialCapacityMB << 20);
            DataFileWriter<GenericRecord> inMemoryWriter = this.createMemoryFileWriter(options, schema, recordsBuffer);
            this.schema = schema;
            this.recordsBuffer = recordsBuffer;
            this.memoryWriter = inMemoryWriter.setSyncInterval(options.getAvroSyncInterval());
            this.headerPosition = inMemoryWriter.sync();
            this.options = options;
            this.syncs = new LinkedList();
            this.syncs.add(this.memoryWriter.sync());
            this.keyValueFields = keyValueFields;
        }

        private DataFileWriter<GenericRecord> createMemoryFileWriter(Writer.Options options, Schema schema, ByteArrayOutputStream recordsBuffer) throws IOException {
            GenericData model = options.model;
            DatumWriter datumWriter = model.createDatumWriter(schema);
            DataFileWriter inMemoryWriter = new DataFileWriter(datumWriter).setCodec(options.getCodec()).create(schema, (OutputStream)recordsBuffer);
            return inMemoryWriter;
        }

        public Long sync() throws IOException {
            long sync = this.memoryWriter.sync();
            if (this.syncs.getLast() != sync) {
                this.syncs.add(sync);
            }
            return sync - this.headerPosition;
        }

        public void append(GenericRecord record) throws IOException {
            this.memoryWriter.append((Object)record);
        }

        public void reverseAndClose(FSDataOutputStream output) throws IOException {
            this.sync();
            this.memoryWriter.close();
            try (DataFileWriter fileWriter = new DataFileWriter(this.options.getDataModel().createDatumWriter(this.schema));){
                DatumReader datumReader = this.options.model.createDatumReader(this.schema);
                byte[] rawAvroFileData = this.recordsBuffer.toByteArray();
                SeekableByteArrayInput input = new SeekableByteArrayInput(rawAvroFileData);
                DataFileReader inMemoryReader = (DataFileReader)DataFileReader.openReader((SeekableInput)input, (DatumReader)datumReader);
                long dataSize = (long)rawAvroFileData.length - this.headerPosition;
                fileWriter.setMeta(AvroBtreeFile.DATA_SIZE_KEY, dataSize).setMeta(AvroBtreeFile.KEY_VALUE_HEADER_NAME, this.keyValueFields).setCodec(this.options.getCodec()).setSyncInterval(this.options.getAvroSyncInterval()).create(this.schema, (OutputStream)output);
                ByteBuffer emptyBuffer = ByteBuffer.allocate(0);
                Iterator<Long> reversedBlocks = this.syncs.descendingIterator();
                reversedBlocks.next();
                while (reversedBlocks.hasNext()) {
                    Long sync = reversedBlocks.next();
                    inMemoryReader.seek(sync.longValue());
                    inMemoryReader.hasNext();
                    long count = inMemoryReader.getBlockCount();
                    ByteBuffer block = inMemoryReader.nextBlock();
                    assert (count > 0L);
                    fileWriter.appendEncoded(block);
                    while (--count > 0L) {
                        fileWriter.appendEncoded(emptyBuffer);
                    }
                    fileWriter.sync();
                }
            }
        }
    }

    public static class Writer
    implements Closeable {
        private final Schema mKeySchema;
        private final Schema mValueSchema;
        private final Schema mRecordSchema;
        private GenericData model;
        private final BufferedWriter bufferedWriter;
        private FileSystem fileSystem;
        private final Path filename;
        private final int mInterval;
        private final int mHeight;
        private GenericRecord mPreviousKey;
        private Node curNode;
        private final Node root;

        public Writer(Options options) throws IOException {
            this.root = this.curNode = new Node();
            this.model = options.getDataModel();
            if (null == options.getConfiguration()) {
                throw new IllegalArgumentException("Configuration may not be null");
            }
            this.fileSystem = options.getPath().getFileSystem(options.getConfiguration());
            this.filename = options.getPath();
            this.mKeySchema = options.getKeySchema();
            if (null == this.mKeySchema) {
                throw new IllegalArgumentException("Key schema may not be null");
            }
            this.mValueSchema = options.getValueSchema();
            if (null == this.mValueSchema) {
                throw new IllegalArgumentException("Value schema may not be null");
            }
            this.mInterval = options.getInterval();
            this.mHeight = options.getHeight() - 1;
            if (this.mHeight < 0) {
                throw new RuntimeException("Height must be positive, given: " + options.getHeight());
            }
            if (!this.fileSystem.mkdirs(options.getPath().getParent())) {
                throw new IOException("Unable to create directory: " + options.getPath().getParent());
            }
            logger.debug("Created directory " + options.getPath());
            Path dataFilePath = options.getPath();
            logger.debug("Creating writer for avro data file: " + dataFilePath);
            ArrayList schemaFields = new ArrayList();
            this.mRecordSchema = AvroBtreeFile.createSchema(this.mKeySchema, this.mValueSchema);
            String keys = String.join((CharSequence)",", (CharSequence[])this.mKeySchema.getFields().stream().map(Schema.Field::name).toArray(String[]::new));
            String values = String.join((CharSequence)",", (CharSequence[])this.mValueSchema.getFields().stream().map(Schema.Field::name).toArray(String[]::new));
            String keyValueFields = keys + "|" + values;
            this.bufferedWriter = new BufferedWriter(options, this.mRecordSchema, keyValueFields);
        }

        public void append(GenericRecord key, GenericRecord value) throws IOException {
            if (null != this.mPreviousKey && this.model.compare((Object)key, (Object)this.mPreviousKey, this.mKeySchema) < 0) {
                throw new IllegalArgumentException("Records must be inserted in sorted key order. Attempted to insert key " + key + " after " + this.mPreviousKey + ".");
            }
            this.mPreviousKey = (GenericRecord)this.model.deepCopy(this.mKeySchema, (Object)key);
            GenericData.Record dataRecord = new GenericData.Record(this.mRecordSchema);
            key.getSchema().getFields().stream().map(Schema.Field::name).forEach(f -> dataRecord.put(f, key.get(f)));
            value.getSchema().getFields().stream().map(Schema.Field::name).forEach(f -> dataRecord.put(f, value.get(f)));
            if (this.curNode.height == 0 || this.curNode.records.size() < this.mInterval) {
                this.curNode.addRecord((GenericRecord)dataRecord);
                if (this.curNode.height < this.mHeight) {
                    this.curNode = new Node(this.curNode);
                }
            } else {
                while (this.curNode.records.size() == this.mInterval && this.curNode.height > 0) {
                    this.flush();
                }
                this.curNode.addRecord((GenericRecord)dataRecord);
                this.curNode = new Node(this.curNode);
            }
        }

        @Override
        public void close() throws IOException {
            while (this.curNode != this.root) {
                this.flush();
            }
            this.flush();
            this.bufferedWriter.reverseAndClose(this.fileSystem.create(this.filename));
        }

        private void flush() throws IOException {
            int numRecordsWriting = this.curNode.records.size();
            logger.debug("writing {} records in height {}, records: {}", new Object[]{numRecordsWriting, this.curNode.height, this.curNode.records});
            for (GenericRecord record : this.curNode.records) {
                this.bufferedWriter.append(record);
            }
            long position = this.bufferedWriter.sync();
            this.curNode = this.curNode.prev;
            if (this.curNode != null && numRecordsWriting > 0) {
                this.curNode.getCurRecord().put(AvroBtreeFile.METADATA_COL_NAME, (Object)position);
            }
        }

        public static class Options {
            private Schema mKeySchema;
            private Schema mValueSchema;
            private Configuration mConf;
            private Path mPath;
            private int mInterval = 128;
            private int mHeight = 2;
            private int initialCapacityMB = 20;
            private int avroSyncInterval = 0xA00000;
            private GenericData model = SpecificData.get();
            private CodecFactory codec = CodecFactory.nullCodec();

            public Options withKeySchema(Schema keySchema) {
                this.mKeySchema = keySchema;
                return this;
            }

            public Schema getKeySchema() {
                return this.mKeySchema;
            }

            public Options withValueSchema(Schema valueSchema) {
                this.mValueSchema = valueSchema;
                return this;
            }

            public Schema getValueSchema() {
                return this.mValueSchema;
            }

            public Options withConfiguration(Configuration conf) {
                this.mConf = conf;
                return this;
            }

            public Configuration getConfiguration() {
                return this.mConf;
            }

            public Options withPath(Path path) {
                this.mPath = path;
                return this;
            }

            public Path getPath() {
                return this.mPath;
            }

            public Options withInterval(int interval) {
                this.mInterval = interval;
                return this;
            }

            public int getInterval() {
                return this.mInterval;
            }

            public Options withHeight(int height) {
                this.mHeight = height;
                return this;
            }

            public int getHeight() {
                return this.mHeight;
            }

            public Options withDataModel(GenericData model) {
                this.model = model;
                return this;
            }

            public GenericData getDataModel() {
                return this.model;
            }

            public Options withCodec(String codec) {
                this.codec = CodecFactory.fromString((String)codec);
                return this;
            }

            public Options withCodec(CodecFactory codec) {
                this.codec = codec;
                return this;
            }

            public Options withInitialBufferSizeMB(int mb) {
                this.initialCapacityMB = mb;
                return this;
            }

            public CodecFactory getCodec() {
                return this.codec;
            }

            public int getAvroSyncInterval() {
                return this.avroSyncInterval;
            }

            public Options withAvroSyncInterval(int avroSyncInterval) {
                this.avroSyncInterval = avroSyncInterval;
                return this;
            }
        }

        private class Node {
            List<GenericRecord> records;
            Node prev;
            int height;

            public Node() {
                this.records = new ArrayList<GenericRecord>(Writer.this.mInterval);
            }

            public Node(Node prevNode) {
                this.records = new ArrayList<GenericRecord>(Writer.this.mInterval);
                this.prev = prevNode;
                this.height = prevNode.height + 1;
            }

            public GenericRecord getCurRecord() {
                return this.records.get(this.records.size() - 1);
            }

            public void addRecord(GenericRecord record) throws IOException {
                this.records.add(record);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                for (GenericRecord md : this.records) {
                    sb.append("\n\t\t");
                    sb.append(" data: " + md.toString());
                }
                return "Node{records=" + sb + ", height=" + this.height + '}';
            }
        }
    }

    public static class Reader
    implements Closeable {
        private final Long dataSize;
        private final long fileHeaderEnd;
        private final DataFileReader<GenericRecord> mFileReader;
        private final Schema mKeySchema;
        private final Schema mValueSchema;

        public Schema getKeySchema() {
            return this.mKeySchema;
        }

        public Schema getValueSchema() {
            return this.mValueSchema;
        }

        public Reader(Options options) throws IOException {
            Path dataFilePath = options.getPath();
            logger.debug("Loading the data file " + dataFilePath);
            DatumReader datumReader = GenericData.get().createDatumReader(null);
            this.mFileReader = new DataFileReader((SeekableInput)new FsInput(dataFilePath, options.getConfiguration()), datumReader);
            String[] split = this.mFileReader.getMetaString(AvroBtreeFile.KEY_VALUE_HEADER_NAME).split("\\|");
            this.mKeySchema = AvroBtreeFile.projectSchema(this.mFileReader.getSchema(), split[0].split(","));
            this.mValueSchema = AvroBtreeFile.projectSchema(this.mFileReader.getSchema(), split[1].split(","));
            this.fileHeaderEnd = this.mFileReader.previousSync();
            this.dataSize = this.mFileReader.getMetaLong(AvroBtreeFile.DATA_SIZE_KEY);
        }

        public void sync(Long syncPosition) throws IOException {
            this.mFileReader.sync(syncPosition.longValue());
        }

        public Iterator<GenericRecord> get(final GenericRecord key) {
            logger.debug("searching for key: {}", (Object)key);
            return new Iterator<GenericRecord>(){
                long curOffset;
                GenericRecord lastRecord = null;
                int counter;
                long blockCount;
                private RecordProjection projection = new RecordProjection(Reader.access$200(this), Reader.access$300(this));
                GenericRecord nxt = this.getNextFromOffset(0L);

                @Override
                public boolean hasNext() {
                    return this.nxt != null;
                }

                @Override
                public GenericRecord next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    GenericRecord ret = this.nxt;
                    this.nxt = this.getNext();
                    return ret;
                }

                private GenericRecord getNextFromOffset(long offset) {
                    this.curOffset = offset;
                    this.init();
                    return this.getNext();
                }

                private void init() {
                    this.curOffset += fileHeaderEnd;
                    logger.debug("seeking to position: " + this.curOffset);
                    this.counter = 0;
                    this.blockCount = -1L;
                    this.lastRecord = null;
                    try {
                        mFileReader.seek(this.curOffset);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    mFileReader.hasNext();
                }

                private GenericRecord getNext() {
                    while (mFileReader.hasNext() && ((long)this.counter < this.blockCount || this.blockCount < 0L)) {
                        GenericRecord record = (GenericRecord)mFileReader.next();
                        if (this.blockCount < 0L) {
                            this.blockCount = mFileReader.getBlockCount();
                        }
                        ++this.counter;
                        int comparison = GenericData.get().compare((Object)this.projection.getKey(record), (Object)key, mKeySchema);
                        logger.debug("comparison was: {} with: {} and {}", new Object[]{comparison, this.projection.getKey(record), key});
                        if (0 == comparison) {
                            logger.debug("Found record for key {}", (Object)key);
                            this.lastRecord = record;
                            return this.projection.getValue(record);
                        }
                        if (comparison > 0) {
                            if (this.lastRecord == null || this.projection.getMetadata(this.lastRecord) == null) {
                                logger.debug("key does not appear in the file: {}", (Object)key);
                                this.curOffset -= fileHeaderEnd;
                                return null;
                            }
                            return this.getNextFromOffset(this.getRealOffset(this.lastRecord));
                        }
                        this.lastRecord = record;
                    }
                    if (this.lastRecord != null && this.projection.getMetadata(this.lastRecord) != null) {
                        return this.getNextFromOffset(this.getRealOffset(this.lastRecord));
                    }
                    logger.debug("reached end of road. key does not appear in the file: {}", (Object)key);
                    return null;
                }
            };
        }

        private Long getRealOffset(GenericRecord record) {
            Long offset = this.dataSize;
            Long reversedOffset = (Long)record.get(AvroBtreeFile.METADATA_COL_NAME);
            if (reversedOffset != null) {
                offset = offset - reversedOffset;
            }
            return offset;
        }

        public Iterator<GenericRecord> getIterator() {
            return new Iterator<GenericRecord>(){
                private final RecordProjection projection;
                private Node next;
                {
                    this.projection = new RecordProjection(mKeySchema, mValueSchema);
                    this.next = new Node(0L);
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public GenericRecord next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    GenericRecord ret = this.next.getCurGenericRecord();
                    if (this.next.curHasChild()) {
                        this.next = this.next.getChildNode();
                    } else {
                        ++this.next.curRecord;
                        while (this.next.curRecord == this.next.records.size()) {
                            this.next = this.next.parent;
                            if (this.next == null) {
                                return ret;
                            }
                            ++this.next.curRecord;
                        }
                    }
                    return ret;
                }

                class Node {
                    int curRecord = 0;
                    final List<GenericRecord> records;
                    Node parent;

                    Node(long offset) {
                        try {
                            mFileReader.seek(fileHeaderEnd + offset);
                            GenericRecord firstRecord = (GenericRecord)mFileReader.next();
                            int blockCount = (int)mFileReader.getBlockCount();
                            this.records = new ArrayList<GenericRecord>(blockCount);
                            this.records.add(firstRecord);
                            for (int i = 1; i < blockCount; ++i) {
                                this.records.add((GenericRecord)mFileReader.next());
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }

                    boolean curHasChild() {
                        return projection.getMetadata(this.records.get(this.curRecord)) != null;
                    }

                    Node getChildNode() {
                        Node childNode = new Node(this.getRealOffset(this.records.get(this.curRecord)));
                        childNode.parent = this;
                        return childNode;
                    }

                    GenericRecord getCurGenericRecord() {
                        return this.records.get(this.curRecord);
                    }
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.mFileReader.close();
        }

        public static class Options {
            private Configuration mConf;
            private Path mPath;

            public Options withConfiguration(Configuration conf) {
                this.mConf = conf;
                return this;
            }

            public Configuration getConfiguration() {
                return this.mConf;
            }

            public Options withPath(Path path) {
                this.mPath = path;
                return this;
            }

            public Path getPath() {
                return this.mPath;
            }
        }
    }
}

