/*
 * Decompiled with CFR 0.152.
 */
package com.paulgoldbaum.influxdbclient;

import com.paulgoldbaum.influxdbclient.ErrorResponseException;
import com.paulgoldbaum.influxdbclient.ErrorResponseException$;
import com.paulgoldbaum.influxdbclient.MalformedResponseException;
import com.paulgoldbaum.influxdbclient.MalformedResponseException$;
import com.paulgoldbaum.influxdbclient.QueryResult;
import com.paulgoldbaum.influxdbclient.Record;
import com.paulgoldbaum.influxdbclient.Series;
import com.paulgoldbaum.influxdbclient.TagSet;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector$;
import scala.math.BigDecimal;
import scala.runtime.BoxesRunTime;
import spray.json.JsArray;
import spray.json.JsBoolean;
import spray.json.JsBoolean$;
import spray.json.JsNull$;
import spray.json.JsNumber;
import spray.json.JsObject;
import spray.json.JsObject$;
import spray.json.JsString;
import spray.json.JsValue;
import spray.json.package$;

public final class QueryResult$ {
    public static QueryResult$ MODULE$;

    static {
        new QueryResult$();
    }

    public QueryResult fromJson(String data) {
        JsArray resultsArray = this.parseJson(data);
        JsObject resultObject = (JsObject)resultsArray.elements().head();
        return this.makeSingleResult(resultObject);
    }

    public List<QueryResult> fromJsonMulti(String data) {
        JsArray resultsArray = this.parseJson(data);
        return ((TraversableOnce)resultsArray.elements().map((Function1 & Serializable & scala.Serializable)result -> this.makeSingleResult((JsObject)result), Vector$.MODULE$.canBuildFrom())).toList();
    }

    private QueryResult makeSingleResult(JsObject resultObject) {
        Map fields = resultObject.fields();
        if (fields.contains((Object)"error")) {
            throw new ErrorResponseException(((JsValue)fields.apply((Object)"error")).toString(), ErrorResponseException$.MODULE$.$lessinit$greater$default$2());
        }
        if (!fields.contains((Object)"series")) {
            return new QueryResult(this.$lessinit$greater$default$1());
        }
        JsArray seriesArray = (JsArray)fields.apply((Object)"series");
        List series = ((TraversableOnce)seriesArray.elements().map((Function1 & Serializable & scala.Serializable)value -> this.constructSeries((JsValue)value), Vector$.MODULE$.canBuildFrom())).toList();
        return new QueryResult((List<Series>)series);
    }

    private JsArray parseJson(String data) {
        JsObject root = (JsObject)package$.MODULE$.pimpString(data).parseJson();
        return (JsArray)root.fields().apply((Object)"results");
    }

    public Series constructSeries(JsValue value) {
        Map fields = ((JsObject)value).fields();
        String seriesName = fields.contains((Object)"name") ? ((JsString)fields.apply((Object)"name")).value() : "";
        List columns = ((TraversableOnce)((JsArray)fields.apply((Object)"columns")).elements().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String column;
            JsValue jsValue = x0$1;
            if (!(jsValue instanceof JsString)) {
                throw new MalformedResponseException("Found invalid type " + jsValue.toString(), MalformedResponseException$.MODULE$.$lessinit$greater$default$2());
            }
            JsString jsString = (JsString)jsValue;
            String string = column = jsString.value();
            return string;
        }, Vector$.MODULE$.canBuildFrom())).toList();
        Map tagsIndex = fields.contains((Object)"tags") ? ((TraversableOnce)((JsValue)fields.apply((Object)"tags")).asJsObject().fields().keySet().zipWithIndex(Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()) : Predef$.MODULE$.Map().empty();
        TagSet tags = fields.contains((Object)"tags") ? this.constructTagSet((Map<String, Object>)tagsIndex, (JsValue)fields.apply((Object)"tags")) : this.constructTagSet((Map<String, Object>)Predef$.MODULE$.Map().empty(), (JsValue)JsObject$.MODULE$.empty());
        Map namesIndex = ((TraversableOnce)columns.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Nil$ records = fields.contains((Object)"values") ? ((TraversableOnce)((JsArray)fields.apply((Object)"values")).elements().map((Function1 & Serializable & scala.Serializable)x$4 -> this.constructRecord((Map<String, Object>)namesIndex, (JsValue)x$4), Vector$.MODULE$.canBuildFrom())).toList() : Nil$.MODULE$;
        return new Series(seriesName, (List<String>)columns, (List<Record>)records, tags);
    }

    public Record constructRecord(Map<String, Object> namesIndex, JsValue value) {
        JsArray valueArray = (JsArray)value;
        List values = ((TraversableOnce)valueArray.elements().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            JsBoolean jsBoolean;
            Option option;
            Object object;
            JsValue jsValue = x0$2;
            if (jsValue instanceof JsNumber) {
                BigDecimal num;
                JsNumber jsNumber = (JsNumber)jsValue;
                object = num = jsNumber.value();
            } else if (jsValue instanceof JsString) {
                JsString jsString = (JsString)jsValue;
                String str = jsString.value();
                object = str;
            } else if (jsValue instanceof JsBoolean && !(option = JsBoolean$.MODULE$.unapply(jsBoolean = (JsBoolean)jsValue)).isEmpty()) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)option.get());
                object = BoxesRunTime.boxToBoolean((boolean)bl);
            } else if (JsNull$.MODULE$.equals(jsValue)) {
                object = null;
            } else {
                throw new MalformedResponseException("Found invalid type " + jsValue.toString(), MalformedResponseException$.MODULE$.$lessinit$greater$default$2());
            }
            return object;
        }, Vector$.MODULE$.canBuildFrom())).toList();
        return new Record(namesIndex, (List<Object>)values);
    }

    public TagSet constructTagSet(Map<String, Object> tagsIndex, JsValue value) {
        List values = ((TraversableOnce)value.asJsObject().fields().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            void var1_9;
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JsValue jsValue = (JsValue)tuple2._2();
                if (key != null && jsValue instanceof JsNumber) {
                    BigDecimal num;
                    JsNumber jsNumber = (JsNumber)jsValue;
                    BigDecimal bigDecimal = num = jsNumber.value();
                    return var1_9;
                }
            }
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                JsValue jsValue = (JsValue)tuple2._2();
                if (key != null && jsValue instanceof JsString) {
                    String str;
                    JsString jsString = (JsString)jsValue;
                    String string = str = jsString.value();
                    return var1_9;
                }
            }
            if (tuple2 == null) throw new MalformedResponseException("Found invalid type " + tuple2.toString(), MalformedResponseException$.MODULE$.$lessinit$greater$default$2());
            String key = (String)tuple2._1();
            JsValue jsValue = (JsValue)tuple2._2();
            if (key == null) throw new MalformedResponseException("Found invalid type " + tuple2.toString(), MalformedResponseException$.MODULE$.$lessinit$greater$default$2());
            if (!(jsValue instanceof JsBoolean)) throw new MalformedResponseException("Found invalid type " + tuple2.toString(), MalformedResponseException$.MODULE$.$lessinit$greater$default$2());
            JsBoolean jsBoolean = (JsBoolean)jsValue;
            Option option = JsBoolean$.MODULE$.unapply(jsBoolean);
            if (option.isEmpty()) throw new MalformedResponseException("Found invalid type " + tuple2.toString(), MalformedResponseException$.MODULE$.$lessinit$greater$default$2());
            boolean bl = BoxesRunTime.unboxToBoolean((Object)option.get());
            Boolean bl2 = BoxesRunTime.boxToBoolean((boolean)bl);
            return var1_9;
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        return new TagSet(tagsIndex, (List<Object>)values);
    }

    public List<Series> $lessinit$greater$default$1() {
        return Nil$.MODULE$;
    }

    private QueryResult$() {
        MODULE$ = this;
    }
}

