/*
 * Decompiled with CFR 0.152.
 */
package com.paulgoldbaum.influxdbclient;

import com.paulgoldbaum.influxdbclient.DatabaseManagement;
import com.paulgoldbaum.influxdbclient.DatabaseNotFoundException;
import com.paulgoldbaum.influxdbclient.HttpClient;
import com.paulgoldbaum.influxdbclient.HttpException;
import com.paulgoldbaum.influxdbclient.HttpResponse;
import com.paulgoldbaum.influxdbclient.InfluxDB;
import com.paulgoldbaum.influxdbclient.MalformedRequestException;
import com.paulgoldbaum.influxdbclient.Parameter;
import com.paulgoldbaum.influxdbclient.Point;
import com.paulgoldbaum.influxdbclient.QueryResult;
import com.paulgoldbaum.influxdbclient.RequestNotCompletedException;
import com.paulgoldbaum.influxdbclient.RetentionPolicyManagement;
import com.paulgoldbaum.influxdbclient.ServerUnavailableException;
import com.paulgoldbaum.influxdbclient.UnknownErrorException;
import com.paulgoldbaum.influxdbclient.WriteException;
import java.io.Serializable;
import scala.Function1;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uf\u0001B\u0001\u0003\u0001%\u0011\u0001\u0002R1uC\n\f7/\u001a\u0006\u0003\u0007\u0011\ta\"\u001b8gYVDHMY2mS\u0016tGO\u0003\u0002\u0006\r\u0005a\u0001/Y;mO>dGMY1v[*\tq!A\u0002d_6\u001c\u0001a\u0005\u0003\u0001\u00159\t\u0002CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005!IeN\u001a7vq\u0012\u0013\u0005CA\u0006\u0010\u0013\t\u0001\"AA\rSKR,g\u000e^5p]B{G.[2z\u001b\u0006t\u0017mZ3nK:$\bCA\u0006\u0013\u0013\t\u0019\"A\u0001\nECR\f'-Y:f\u001b\u0006t\u0017mZ3nK:$\b\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0019\u0011\fG/\u00192bg\u0016t\u0015-\\3\u0016\u0003]\u0001\"\u0001G\u0011\u000f\u0005ey\u0002C\u0001\u000e\u001e\u001b\u0005Y\"B\u0001\u000f\t\u0003\u0019a$o\\8u})\ta$A\u0003tG\u0006d\u0017-\u0003\u0002!;\u00051\u0001K]3eK\u001aL!AI\u0012\u0003\rM#(/\u001b8h\u0015\t\u0001S\u0004\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003\u0018\u00035!\u0017\r^1cCN,g*Y7fA!Aq\u0005\u0001B\u0001B\u0003%\u0001&\u0001\u0006iiR\u00048\t\\5f]R\u0004\"aC\u0015\n\u0005)\u0012!A\u0003%uiB\u001cE.[3oi\"AA\u0006\u0001BC\u0002\u0013MS&\u0001\u0002fGV\ta\u0006\u0005\u00020e5\t\u0001G\u0003\u00022;\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005M\u0002$\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011%)\u0004A!A!\u0002\u0013qc'A\u0002fG\u0002J!\u0001\f\u0007\t\ra\u0002A\u0011\u0003\u0002:\u0003\u0019a\u0014N\\5u}Q\u0019!(\u0010 \u0015\u0005mb\u0004CA\u0006\u0001\u0011\u0015as\u0007q\u0001/\u0011\u0015)r\u00071\u0001\u0018\u0011\u00159s\u00071\u0001)\u0011\u0015\u0001\u0005\u0001\"\u0001B\u0003\u00159(/\u001b;f)\u0015\u0011\u0015JT1k!\ry3)R\u0005\u0003\tB\u0012aAR;ukJ,\u0007C\u0001$H\u001b\u0005i\u0012B\u0001%\u001e\u0005\u001d\u0011un\u001c7fC:DQAS A\u0002-\u000bQ\u0001]8j]R\u0004\"a\u0003'\n\u00055\u0013!!\u0002)pS:$\bbB(@!\u0003\u0005\r\u0001U\u0001\naJ,7-[:j_:\u0004\"!\u00150\u000f\u0005I[fBA*Z\u001d\t!\u0006L\u0004\u0002V/:\u0011!DV\u0005\u0002\u000f%\u0011QAB\u0005\u0003\u0007\u0011I!A\u0017\u0002\u0002\u0013A\u000b'/Y7fi\u0016\u0014\u0018B\u0001/^\u0003%\u0001&/Z2jg&|gN\u0003\u0002[\u0005%\u0011q\f\u0019\u0002\n!J,7-[:j_:T!\u0001X/\t\u000f\t|\u0004\u0013!a\u0001G\u0006Y1m\u001c8tSN$XM\\2z!\t!wM\u0004\u0002SK&\u0011a-X\u0001\f\u0007>t7/[:uK:\u001c\u00170\u0003\u0002iS\nY1i\u001c8tSN$XM\\2z\u0015\t1W\fC\u0004l\u007fA\u0005\t\u0019A\f\u0002\u001fI,G/\u001a8uS>t\u0007k\u001c7jGfDQ!\u001c\u0001\u0005\u00029\f\u0011BY;mW^\u0013\u0018\u000e^3\u0015\u000b\t{'p\u001f?\t\u000bAd\u0007\u0019A9\u0002\rA|\u0017N\u001c;t!\r\u0011xo\u0013\b\u0003gVt!A\u0007;\n\u0003yI!A^\u000f\u0002\u000fA\f7m[1hK&\u0011\u00010\u001f\u0002\u0004'\u0016\f(B\u0001<\u001e\u0011\u001dyE\u000e%AA\u0002ACqA\u00197\u0011\u0002\u0003\u00071\rC\u0004lYB\u0005\t\u0019A\f\t\u000by\u0004A\u0011B@\u0002\u0019\u0015DXmY;uK^\u0013\u0018\u000e^3\u0015\u0013\t\u000b\t!!\u0002\u0002\b\u0005%\u0001BBA\u0002{\u0002\u0007q#A\u0004qCfdw.\u00193\t\u000b=k\b\u0019\u0001)\t\u000b\tl\b\u0019A2\t\u000b-l\b\u0019A\f\t\u000f\u00055\u0001\u0001\"\u0003\u0002\u0010\u0005!\"-^5mI^\u0013\u0018\u000e^3QCJ\fW.\u001a;feN$\"\"!\u0005\u0002\u0018\u0005e\u00111DA\u000f!\u0015A\u00121C\f\u0018\u0013\r\t)b\t\u0002\u0004\u001b\u0006\u0004\bBB\u000b\u0002\f\u0001\u0007q\u0003\u0003\u0005P\u0003\u0017\u0001\n\u00111\u0001Q\u0011!\u0011\u00171\u0002I\u0001\u0002\u0004\u0019\u0007\u0002C6\u0002\fA\u0005\t\u0019A\f\t\u000f\u0005\u0005\u0002\u0001\"\u0015\u0002$\u0005!\"-^5mIF+XM]=QCJ\fW.\u001a;feN$b!!\n\u0002B\u0005\u0015\u0003cBA\u0014\u0003c\t\u0019dF\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003_i\u0012AC2pY2,7\r^5p]&!\u0011QCA\u0015!\u0011\t)$a\u0010\u000e\u0005\u0005]\"\u0002BA\u001d\u0003w\tA\u0001\\1oO*\u0011\u0011QH\u0001\u0005U\u00064\u0018-C\u0002#\u0003oAq!a\u0011\u0002 \u0001\u0007q#A\u0003rk\u0016\u0014\u0018\u0010\u0003\u0004P\u0003?\u0001\r\u0001\u0015\u0005\b\u0003\u0013\u0002A\u0011CA&\u0003])\u0007pY3qi&|gN\u0012:p[N#\u0018\r^;t\u0007>$W\r\u0006\u0005\u0002N\u0005M\u0013QLA1!\rY\u0011qJ\u0005\u0004\u0003#\u0012!AD,sSR,W\t_2faRLwN\u001c\u0005\t\u0003+\n9\u00051\u0001\u0002X\u0005Q1\u000f^1ukN\u001cu\u000eZ3\u0011\u0007\u0019\u000bI&C\u0002\u0002\\u\u00111!\u00138u\u0011\u001d\ty&a\u0012A\u0002]\t1a\u001d;s\u0011)\t\u0019'a\u0012\u0011\u0002\u0003\u0007\u0011QM\u0001\ni\"\u0014xn^1cY\u0016\u00042A]A4\u0013\r\tI'\u001f\u0002\n)\"\u0014xn^1cY\u0016D\u0011\"!\u001c\u0001#\u0003%\t!a\u001c\u0002\u001f]\u0014\u0018\u000e^3%I\u00164\u0017-\u001e7uII*\"!!\u001d+\u0007A\u000b\u0019h\u000b\u0002\u0002vA!\u0011qOAA\u001b\t\tIH\u0003\u0003\u0002|\u0005u\u0014!C;oG\",7m[3e\u0015\r\ty(H\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAB\u0003s\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\t9\tAI\u0001\n\u0003\tI)A\bxe&$X\r\n3fM\u0006,H\u000e\u001e\u00134+\t\tYIK\u0002d\u0003gB\u0011\"a$\u0001#\u0003%\t!!%\u0002\u001f]\u0014\u0018\u000e^3%I\u00164\u0017-\u001e7uIQ*\"!a%+\u0007]\t\u0019\bC\u0005\u0002\u0018\u0002\t\n\u0011\"\u0003\u0002p\u0005q\"-^5mI^\u0013\u0018\u000e^3QCJ\fW.\u001a;feN$C-\u001a4bk2$HE\r\u0005\n\u00037\u0003\u0011\u0013!C\u0005\u0003\u0013\u000baDY;jY\u0012<&/\u001b;f!\u0006\u0014\u0018-\\3uKJ\u001cH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005}\u0005!%A\u0005\n\u0005E\u0015A\b2vS2$wK]5uKB\u000b'/Y7fi\u0016\u00148\u000f\n3fM\u0006,H\u000e\u001e\u00135\u0011%\t\u0019\u000bAI\u0001\n#\t)+A\u0011fq\u000e,\u0007\u000f^5p]\u001a\u0013x.\\*uCR,8oQ8eK\u0012\"WMZ1vYR$3'\u0006\u0002\u0002(*\"\u0011QMA:\u0011%\tY\u000bAI\u0001\n\u0003\ty'A\nck2\\wK]5uK\u0012\"WMZ1vYR$#\u0007C\u0005\u00020\u0002\t\n\u0011\"\u0001\u0002\n\u0006\u0019\"-\u001e7l/JLG/\u001a\u0013eK\u001a\fW\u000f\u001c;%g!I\u00111\u0017\u0001\u0012\u0002\u0013\u0005\u0011\u0011S\u0001\u0014EVd7n\u0016:ji\u0016$C-\u001a4bk2$H\u0005\u000e")
public class Database
extends InfluxDB
implements RetentionPolicyManagement,
DatabaseManagement {
    private final String databaseName;
    private final HttpClient httpClient;

    @Override
    public Future<QueryResult> create() {
        return DatabaseManagement.create$(this);
    }

    @Override
    public Future<QueryResult> drop() {
        return DatabaseManagement.drop$(this);
    }

    @Override
    public Future<Object> exists() {
        return DatabaseManagement.exists$(this);
    }

    @Override
    public Future<QueryResult> createRetentionPolicy(String name, String duration, int replication, boolean bl) {
        return RetentionPolicyManagement.createRetentionPolicy$(this, name, duration, replication, bl);
    }

    @Override
    public Future<QueryResult> showRetentionPolicies() {
        return RetentionPolicyManagement.showRetentionPolicies$(this);
    }

    @Override
    public Future<QueryResult> dropRetentionPolicy(String name) {
        return RetentionPolicyManagement.dropRetentionPolicy$(this, name);
    }

    @Override
    public Future<QueryResult> alterRetentionPolicy(String name, String duration, int replication, boolean bl) {
        return RetentionPolicyManagement.alterRetentionPolicy$(this, name, duration, replication, bl);
    }

    @Override
    public String alterRetentionPolicy$default$2() {
        return RetentionPolicyManagement.alterRetentionPolicy$default$2$(this);
    }

    @Override
    public int alterRetentionPolicy$default$3() {
        return RetentionPolicyManagement.alterRetentionPolicy$default$3$(this);
    }

    @Override
    public boolean alterRetentionPolicy$default$4() {
        return RetentionPolicyManagement.alterRetentionPolicy$default$4$(this);
    }

    public String databaseName() {
        return this.databaseName;
    }

    @Override
    public ExecutionContext ec() {
        return super.ec();
    }

    public Future<Object> write(Point point, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        return this.executeWrite(point.serialize(), precision, consistency, retentionPolicy);
    }

    public Parameter.Precision.Precision write$default$2() {
        return null;
    }

    public Parameter.Consistency.Consistency write$default$3() {
        return null;
    }

    public String write$default$4() {
        return null;
    }

    public Future<Object> bulkWrite(Seq<Point> points, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        String payload = ((TraversableOnce)points.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.serialize(), Seq$.MODULE$.canBuildFrom())).mkString("\n");
        return this.executeWrite(payload, precision, consistency, retentionPolicy);
    }

    public Parameter.Precision.Precision bulkWrite$default$2() {
        return null;
    }

    public Parameter.Consistency.Consistency bulkWrite$default$3() {
        return null;
    }

    public String bulkWrite$default$4() {
        return null;
    }

    private Future<Object> executeWrite(String payload, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        Map<String, String> params = this.buildWriteParameters(this.databaseName(), precision, consistency, retentionPolicy);
        return this.httpClient.post("/write", params, payload).recover((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Database $outer;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof HttpException) {
                    HttpException httpException = (HttpException)A1;
                    throw this.$outer.exceptionFromStatusCode(httpException.code(), "Error during write: " + httpException.getMessage(), httpException);
                }
                Object object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                boolean bl = throwable instanceof HttpException;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.ec()).map((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)Database.$anonfun$executeWrite$1(this, result)), this.ec());
    }

    private Map<String, String> buildWriteParameters(String databaseName, Parameter.Precision.Precision precision, Parameter.Consistency.Consistency consistency, String retentionPolicy) {
        List params = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"db", (Object)databaseName), new Tuple2((Object)"precision", (Object)precision), new Tuple2((Object)"consistency", (Object)consistency), new Tuple2((Object)"rp", (Object)retentionPolicy)}));
        return ((TraversableOnce)((List)params.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Database.$anonfun$buildWriteParameters$1(x$2)))).map((Function1 & Serializable & scala.Serializable)r -> new Tuple2(r._1(), (Object)r._2().toString()), List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Parameter.Precision.Precision buildWriteParameters$default$2() {
        return null;
    }

    private Parameter.Consistency.Consistency buildWriteParameters$default$3() {
        return null;
    }

    private String buildWriteParameters$default$4() {
        return null;
    }

    @Override
    public Map<String, String> buildQueryParameters(String query, Parameter.Precision.Precision precision) {
        return super.buildQueryParameters(query, precision).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"db"), (Object)this.databaseName()));
    }

    public WriteException exceptionFromStatusCode(int statusCode, String str, Throwable throwable) {
        WriteException writeException;
        int n = statusCode;
        switch (n) {
            case 200: {
                writeException = new RequestNotCompletedException(str, throwable);
                break;
            }
            case 404: {
                writeException = new DatabaseNotFoundException(str, throwable);
                break;
            }
            default: {
                if (400 <= n && n <= 499) {
                    writeException = new MalformedRequestException(str, throwable);
                    break;
                }
                if (500 <= n && n <= 599) {
                    writeException = new ServerUnavailableException(str, throwable);
                    break;
                }
                writeException = new UnknownErrorException(str, throwable);
                break;
            }
        }
        return writeException;
    }

    public Throwable exceptionFromStatusCode$default$3() {
        return null;
    }

    public static final /* synthetic */ boolean $anonfun$executeWrite$1(Database $this, HttpResponse result) {
        if (result.code() != 204) {
            throw $this.exceptionFromStatusCode(result.code(), "Error during write: " + result.content(), $this.exceptionFromStatusCode$default$3());
        }
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$buildWriteParameters$1(Tuple2 x$2) {
        return x$2._2() == null;
    }

    public Database(String databaseName, HttpClient httpClient, ExecutionContext ec) {
        this.databaseName = databaseName;
        this.httpClient = httpClient;
        super(httpClient, ec);
        RetentionPolicyManagement.$init$(this);
        DatabaseManagement.$init$(this);
    }
}

