/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.soupbintcp;

import com.paritytrading.nassau.Clock;
import com.paritytrading.nassau.MessageListener;
import com.paritytrading.nassau.soupbintcp.SoupBinTCP;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPServerStatusListener;
import com.paritytrading.nassau.soupbintcp.SoupBinTCPSession;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class SoupBinTCPServer
extends SoupBinTCPSession {
    private static final int MIN_MAX_PAYLOAD_LENGTH = 46;
    private final SoupBinTCP.LoginRequest loginRequest = new SoupBinTCP.LoginRequest();
    private final ByteBuffer txPayload = ByteBuffer.allocateDirect(30);
    private final MessageListener listener;
    private final SoupBinTCPServerStatusListener statusListener;

    public SoupBinTCPServer(SocketChannel channel, MessageListener listener, SoupBinTCPServerStatusListener statusListener) {
        this(channel, 65534, listener, statusListener);
    }

    public SoupBinTCPServer(SocketChannel channel, int maxPayloadLength, MessageListener listener, SoupBinTCPServerStatusListener statusListener) {
        this(System::currentTimeMillis, channel, maxPayloadLength, listener, statusListener);
    }

    public SoupBinTCPServer(Clock clock, SocketChannel channel, int maxPayloadLength, MessageListener listener, SoupBinTCPServerStatusListener statusListener) {
        super(clock, channel, Math.max(46, maxPayloadLength), (byte)72);
        this.listener = listener;
        this.statusListener = statusListener;
    }

    public void accept(SoupBinTCP.LoginAccepted payload) throws IOException {
        this.txPayload.clear();
        payload.put(this.txPayload);
        this.txPayload.flip();
        this.send((byte)65, this.txPayload);
    }

    public void reject(SoupBinTCP.LoginRejected payload) throws IOException {
        this.txPayload.clear();
        payload.put(this.txPayload);
        this.txPayload.flip();
        this.send((byte)74, this.txPayload);
    }

    public void endSession() throws IOException {
        this.send((byte)90);
    }

    public void send(ByteBuffer buffer) throws IOException {
        this.send((byte)83, buffer);
    }

    @Override
    void heartbeatTimeout() throws IOException {
        this.statusListener.heartbeatTimeout(this);
    }

    @Override
    void packet(byte packetType, ByteBuffer payload) throws IOException {
        switch (packetType) {
            case 43: {
                break;
            }
            case 76: {
                this.loginRequest.get(payload);
                this.statusListener.loginRequest(this, this.loginRequest);
                break;
            }
            case 85: {
                this.listener.message(payload);
                break;
            }
            case 82: {
                break;
            }
            case 79: {
                this.statusListener.logoutRequest(this);
                break;
            }
            default: {
                this.unexpectedPacketType(packetType);
            }
        }
    }
}

