/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.soupbintcp;

import com.paritytrading.foundation.ASCII;
import java.io.IOException;
import java.nio.ByteBuffer;

public class SoupBinTCP {
    static final byte PACKET_TYPE_DEBUG = 43;
    static final byte PACKET_TYPE_LOGIN_ACCEPTED = 65;
    static final byte PACKET_TYPE_LOGIN_REJECTED = 74;
    static final byte PACKET_TYPE_SEQUENCED_DATA = 83;
    static final byte PACKET_TYPE_SERVER_HEARTBEAT = 72;
    static final byte PACKET_TYPE_END_OF_SESSION = 90;
    static final byte PACKET_TYPE_LOGIN_REQUEST = 76;
    static final byte PACKET_TYPE_UNSEQUENCED_DATA = 85;
    static final byte PACKET_TYPE_CLIENT_HEARTBEAT = 82;
    static final byte PACKET_TYPE_LOGOUT_REQUEST = 79;
    static final int MAX_PACKET_LENGTH = 65535;
    public static final byte LOGIN_REJECT_CODE_NOT_AUTHORIZED = 65;
    public static final byte LOGIN_REJECT_CODE_SESSION_NOT_AVAILABLE = 83;

    private SoupBinTCP() {
    }

    public static class LoginRequest {
        private byte[] username = new byte[6];
        private byte[] password = new byte[10];
        private byte[] requestedSession = new byte[10];
        private byte[] requestedSequenceNumber = new byte[20];

        void get(ByteBuffer buffer) throws IOException {
            buffer.get(this.username);
            buffer.get(this.password);
            buffer.get(this.requestedSession);
            buffer.get(this.requestedSequenceNumber);
        }

        void put(ByteBuffer buffer) {
            buffer.put(this.username);
            buffer.put(this.password);
            buffer.put(this.requestedSession);
            buffer.put(this.requestedSequenceNumber);
        }

        public String getUsername() {
            return ASCII.get((byte[])this.username);
        }

        public void setUsername(String username) {
            ASCII.putLeft((byte[])this.username, (CharSequence)username);
        }

        public String getPassword() {
            return ASCII.get((byte[])this.password);
        }

        public void setPassword(String password) {
            ASCII.putLeft((byte[])this.password, (CharSequence)password);
        }

        public String getRequestedSession() {
            return ASCII.get((byte[])this.requestedSession);
        }

        public void setRequestedSession(String requestedSession) {
            ASCII.putRight((byte[])this.requestedSession, (CharSequence)requestedSession);
        }

        public long getRequestedSequenceNumber() {
            return ASCII.getLong((byte[])this.requestedSequenceNumber);
        }

        public void setRequestedSequenceNumber(long requestedSequenceNumber) {
            ASCII.putLongRight((byte[])this.requestedSequenceNumber, (long)requestedSequenceNumber);
        }
    }

    public static class LoginRejected {
        private byte rejectReasonCode;

        void get(ByteBuffer buffer) {
            this.rejectReasonCode = buffer.get();
        }

        void put(ByteBuffer buffer) {
            buffer.put(this.rejectReasonCode);
        }

        public byte getRejectReasonCode() {
            return this.rejectReasonCode;
        }

        public void setRejectReasonCode(byte rejectReasonCode) {
            this.rejectReasonCode = rejectReasonCode;
        }
    }

    public static class LoginAccepted {
        private byte[] session = new byte[10];
        private byte[] sequenceNumber = new byte[20];

        void get(ByteBuffer buffer) throws IOException {
            buffer.get(this.session);
            buffer.get(this.sequenceNumber);
        }

        void put(ByteBuffer buffer) {
            buffer.put(this.session);
            buffer.put(this.sequenceNumber);
        }

        public String getSession() {
            return ASCII.get((byte[])this.session);
        }

        public void setSession(String session) {
            ASCII.putRight((byte[])this.session, (CharSequence)session);
        }

        public long getSequenceNumber() {
            return ASCII.getLong((byte[])this.sequenceNumber);
        }

        public void setSequenceNumber(long sequenceNumber) {
            ASCII.putLongRight((byte[])this.sequenceNumber, (long)sequenceNumber);
        }
    }
}

