/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.moldudp64;

import com.paritytrading.foundation.ByteBuffers;
import com.paritytrading.nassau.Clock;
import com.paritytrading.nassau.MessageListener;
import com.paritytrading.nassau.moldudp64.MoldUDP64ClientState;
import com.paritytrading.nassau.moldudp64.MoldUDP64ClientStatusListener;
import com.paritytrading.nassau.moldudp64.MoldUDP64Exception;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.DatagramChannel;

public class MoldUDP64Client
implements Closeable {
    private static final int RX_BUFFER_LENGTH = 65535;
    private static final long REQUEST_UNTIL_SEQUENCE_NUMBER_UNKNOWN = -1L;
    private static final long REQUEST_TIMEOUT_MILLIS = 1000L;
    private final Clock clock;
    private final DatagramChannel channel;
    private final DatagramChannel requestChannel;
    private final SocketAddress requestAddress;
    private final MessageListener listener;
    private final MoldUDP64ClientStatusListener statusListener;
    private final ByteBuffer rxBuffer;
    private final ByteBuffer txBuffer;
    private final byte[] session;
    private long nextExpectedSequenceNumber;
    private long requestUntilSequenceNumber;
    private long requestSentMillis;

    MoldUDP64Client(Clock clock, DatagramChannel channel, DatagramChannel requestChannel, SocketAddress requestAddress, MessageListener listener, MoldUDP64ClientStatusListener statusListener, long requestedSequenceNumber) {
        this.clock = clock;
        this.channel = channel;
        this.requestChannel = requestChannel;
        this.requestAddress = requestAddress;
        this.listener = listener;
        this.statusListener = statusListener;
        this.rxBuffer = ByteBuffer.allocateDirect(65535);
        this.txBuffer = ByteBuffer.allocateDirect(20);
        this.session = new byte[10];
        this.nextExpectedSequenceNumber = Math.max(0L, requestedSequenceNumber);
        this.requestUntilSequenceNumber = -1L;
        this.requestSentMillis = 0L;
    }

    public MoldUDP64Client(DatagramChannel channel, SocketAddress requestAddress, MessageListener listener, MoldUDP64ClientStatusListener statusListener) {
        this(System::currentTimeMillis, channel, channel, requestAddress, listener, statusListener, 1L);
    }

    public MoldUDP64Client(DatagramChannel channel, SocketAddress requestAddress, MessageListener listener, MoldUDP64ClientStatusListener statusListener, long requestedSequenceNumber) {
        this(System::currentTimeMillis, channel, channel, requestAddress, listener, statusListener, requestedSequenceNumber);
    }

    public MoldUDP64Client(DatagramChannel channel, DatagramChannel requestChannel, SocketAddress requestAddress, MessageListener listener, MoldUDP64ClientStatusListener statusListener) {
        this(System::currentTimeMillis, channel, requestChannel, requestAddress, listener, statusListener, 1L);
    }

    public MoldUDP64Client(DatagramChannel channel, DatagramChannel requestChannel, SocketAddress requestAddress, MessageListener listener, MoldUDP64ClientStatusListener statusListener, long requestedSequenceNumber) {
        this(System::currentTimeMillis, channel, requestChannel, requestAddress, listener, statusListener, requestedSequenceNumber);
    }

    public DatagramChannel getChannel() {
        return this.channel;
    }

    public DatagramChannel getRequestChannel() {
        return this.requestChannel;
    }

    public boolean receive() throws IOException {
        this.rxBuffer.clear();
        if (this.channel.receive(this.rxBuffer) == null) {
            return false;
        }
        this.rxBuffer.flip();
        this.handle();
        return true;
    }

    public boolean receiveResponse() throws IOException {
        this.rxBuffer.clear();
        if (this.requestChannel.receive(this.rxBuffer) == null) {
            return false;
        }
        this.rxBuffer.flip();
        this.handle();
        return true;
    }

    public void setNextExpectedSequenceNumber(long nextExpectedSequenceNumber) {
        this.nextExpectedSequenceNumber = nextExpectedSequenceNumber;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
        if (this.requestChannel != this.channel) {
            this.requestChannel.close();
        }
    }

    private void handle() throws IOException {
        boolean endOfSession;
        if (this.rxBuffer.remaining() < 20) {
            this.truncatedPacket();
        }
        this.rxBuffer.order(ByteOrder.BIG_ENDIAN);
        this.rxBuffer.get(this.session);
        long sequenceNumber = this.rxBuffer.getLong();
        int messageCount = ByteBuffers.getUnsignedShort((ByteBuffer)this.rxBuffer);
        boolean bl = endOfSession = messageCount == 65535;
        if (endOfSession) {
            messageCount = 0;
        }
        long nextSequenceNumber = sequenceNumber + (long)messageCount;
        if (this.nextExpectedSequenceNumber == 0L) {
            this.nextExpectedSequenceNumber = sequenceNumber;
        }
        if (sequenceNumber > this.nextExpectedSequenceNumber) {
            if (this.requestUntilSequenceNumber == -1L) {
                this.statusListener.state(this, MoldUDP64ClientState.BACKFILL);
                this.requestUntilSequenceNumber = nextSequenceNumber;
                this.request(this.nextExpectedSequenceNumber);
            } else if (this.requestUntilSequenceNumber == 0L) {
                this.statusListener.state(this, MoldUDP64ClientState.GAP_FILL);
                this.requestUntilSequenceNumber = nextSequenceNumber;
                this.request(this.nextExpectedSequenceNumber);
            } else {
                this.requestUntilSequenceNumber = Math.max(this.requestUntilSequenceNumber, nextSequenceNumber);
                if (this.clock.currentTimeMillis() - this.requestSentMillis > 1000L) {
                    this.request(this.nextExpectedSequenceNumber);
                }
            }
        } else {
            if (this.requestUntilSequenceNumber != 0L) {
                if (this.requestUntilSequenceNumber == -1L) {
                    this.requestUntilSequenceNumber = 0L;
                    this.statusListener.state(this, MoldUDP64ClientState.SYNCHRONIZED);
                } else if (this.requestUntilSequenceNumber == nextSequenceNumber) {
                    this.requestUntilSequenceNumber = 0L;
                    this.statusListener.state(this, MoldUDP64ClientState.SYNCHRONIZED);
                } else {
                    this.request(nextSequenceNumber);
                }
            }
            if (endOfSession) {
                this.statusListener.endOfSession(this);
            } else {
                long skipUntilSequenceNumber = Math.min(nextSequenceNumber, this.nextExpectedSequenceNumber);
                for (long s = sequenceNumber; s < skipUntilSequenceNumber; ++s) {
                    this.skip();
                }
                while (this.nextExpectedSequenceNumber < nextSequenceNumber) {
                    this.read();
                    ++this.nextExpectedSequenceNumber;
                }
            }
            this.statusListener.downstream(this, sequenceNumber, messageCount);
        }
    }

    private void request(long requestFromSequenceNumber) throws IOException {
        int requestedMessageCount = (int)Math.min(this.requestUntilSequenceNumber - requestFromSequenceNumber, 65534L);
        this.txBuffer.clear();
        this.txBuffer.put(this.session);
        this.txBuffer.putLong(requestFromSequenceNumber);
        ByteBuffers.putUnsignedShort((ByteBuffer)this.txBuffer, (int)requestedMessageCount);
        this.txBuffer.flip();
        while (this.requestChannel.send(this.txBuffer, this.requestAddress) == 0) {
        }
        this.statusListener.request(this, requestFromSequenceNumber, requestedMessageCount);
        this.requestSentMillis = this.clock.currentTimeMillis();
    }

    private void read() throws IOException {
        int messageLength = this.readMessageLength();
        if (this.rxBuffer.remaining() < messageLength) {
            this.truncatedPacket();
        }
        int limit = this.rxBuffer.limit();
        this.rxBuffer.limit(this.rxBuffer.position() + messageLength);
        this.listener.message(this.rxBuffer);
        this.rxBuffer.position(this.rxBuffer.limit());
        this.rxBuffer.limit(limit);
    }

    private void skip() throws IOException {
        int messageLength = this.readMessageLength();
        if (this.rxBuffer.remaining() < messageLength) {
            this.truncatedPacket();
        }
        this.rxBuffer.position(this.rxBuffer.position() + messageLength);
    }

    private int readMessageLength() throws IOException {
        if (this.rxBuffer.remaining() < 2) {
            this.truncatedPacket();
        }
        this.rxBuffer.order(ByteOrder.BIG_ENDIAN);
        return ByteBuffers.getUnsignedShort((ByteBuffer)this.rxBuffer);
    }

    private void truncatedPacket() throws MoldUDP64Exception {
        throw new MoldUDP64Exception("Truncated packet");
    }
}

