/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.binaryfile;

import com.paritytrading.foundation.ByteBuffers;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

public class BinaryFILEWriter
implements Closeable {
    private static final long DEFAULT_SIZE = 0x8000000L;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocateDirect(0);
    private final RandomAccessFile file;
    private final FileChannel channel;
    private final long size;
    private long position;
    private ByteBuffer buffer;

    private BinaryFILEWriter(RandomAccessFile file, long size) {
        this.file = file;
        this.channel = file.getChannel();
        this.size = size;
        this.position = 0L;
        this.buffer = EMPTY_BUFFER;
    }

    public static BinaryFILEWriter open(File file) throws IOException {
        return BinaryFILEWriter.open(file, 0x8000000L);
    }

    public static BinaryFILEWriter open(File file, long size) throws IOException {
        return new BinaryFILEWriter(new RandomAccessFile(file, "rw"), size);
    }

    public void write(ByteBuffer payload) throws IOException {
        if (this.buffer.remaining() < 2 + payload.remaining()) {
            this.map();
        }
        ByteBuffers.putUnsignedShort((ByteBuffer)this.buffer, (int)payload.remaining());
        this.buffer.put(payload);
    }

    @Override
    public void close() throws IOException {
        this.file.setLength(this.position + (long)this.buffer.position());
        this.file.close();
    }

    private void map() throws IOException {
        this.position += (long)this.buffer.position();
        this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, this.position, this.size);
    }
}

