/*
 * Decompiled with CFR 0.152.
 */
package com.paritytrading.nassau.binaryfile;

import com.paritytrading.foundation.ByteBuffers;
import com.paritytrading.nassau.MessageListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.GZIPInputStream;

public class BinaryFILEReader
implements Closeable {
    private static final int BUFFER_SIZE = 131072;
    private static final int GZIP_BUFFER_SIZE = 65536;
    private final ReadableByteChannel channel;
    private final MessageListener listener;
    private final ByteBuffer buffer;

    public BinaryFILEReader(InputStream stream, MessageListener listener) {
        this(Channels.newChannel(stream), listener);
    }

    public BinaryFILEReader(ReadableByteChannel channel, MessageListener listener) {
        this.channel = channel;
        this.listener = listener;
        this.buffer = ByteBuffer.allocateDirect(131072);
    }

    public static BinaryFILEReader open(File file, MessageListener listener) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        if (file.getName().endsWith(".gz")) {
            return new BinaryFILEReader(new GZIPInputStream((InputStream)stream, 65536), listener);
        }
        return new BinaryFILEReader(stream.getChannel(), listener);
    }

    public int read() throws IOException {
        int bytes = this.channel.read(this.buffer);
        if (bytes <= 0) {
            return bytes;
        }
        this.buffer.flip();
        while (this.parse()) {
        }
        this.buffer.compact();
        return bytes;
    }

    private boolean parse() throws IOException {
        if (this.buffer.remaining() < 2) {
            return false;
        }
        this.buffer.mark();
        this.buffer.order(ByteOrder.BIG_ENDIAN);
        int payloadLength = ByteBuffers.getUnsignedShort((ByteBuffer)this.buffer);
        if (this.buffer.remaining() < payloadLength) {
            this.buffer.reset();
            return false;
        }
        int limit = this.buffer.limit();
        this.buffer.limit(this.buffer.position() + payloadLength);
        this.listener.message(this.buffer);
        this.buffer.position(this.buffer.limit());
        this.buffer.limit(limit);
        return true;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

