/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.codahale.metrics.Snapshot;
import com.codahale.metrics.WeightedSnapshot;
import com.google.common.collect.ImmutableList;
import com.palantir.tritium.metrics.registry.DefaultLongExemplar;
import com.palantir.tritium.metrics.registry.ExemplarMetadataProvider;
import com.palantir.tritium.metrics.registry.ExemplarsCapture;
import com.palantir.tritium.metrics.registry.LongExemplar;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;

final class WeightedSnapshotWithExemplars
extends Snapshot
implements ExemplarsCapture {
    private final WeightedSnapshot weightedSnapshot;
    private final ExemplarMetadataProvider<?> exemplarProvider;
    private final List<LongExemplar<Object>> exemplars;

    WeightedSnapshotWithExemplars(ExemplarMetadataProvider<?> provider, Collection<WeightedSampleWithExemplar> values) {
        ImmutableList.Builder weightedSamplesBuilder = ImmutableList.builderWithExpectedSize((int)values.size());
        ImmutableList.Builder exemplarsBuilder = null;
        for (WeightedSampleWithExemplar v : values) {
            weightedSamplesBuilder.add((Object)new WeightedSnapshot.WeightedSample(v.value, v.weight));
            if (v.exemplarMetadata == null) continue;
            if (exemplarsBuilder == null) {
                exemplarsBuilder = ImmutableList.builder();
            }
            exemplarsBuilder.add(DefaultLongExemplar.of(v.exemplarMetadata, v.value));
        }
        this.exemplars = exemplarsBuilder == null ? ImmutableList.of() : exemplarsBuilder.build();
        this.weightedSnapshot = new WeightedSnapshot((Collection)weightedSamplesBuilder.build());
        this.exemplarProvider = provider;
    }

    public <U> List<LongExemplar<U>> getSamples(ExemplarMetadataProvider<U> provider) {
        if (this.exemplarProvider == provider) {
            return this.exemplars;
        }
        return List.of();
    }

    public double getValue(double quantile) {
        return this.weightedSnapshot.getValue(quantile);
    }

    public long[] getValues() {
        return this.weightedSnapshot.getValues();
    }

    public int size() {
        return this.weightedSnapshot.size();
    }

    public long getMax() {
        return this.weightedSnapshot.getMax();
    }

    public double getMean() {
        return this.weightedSnapshot.getMean();
    }

    public long getMin() {
        return this.weightedSnapshot.getMin();
    }

    public double getStdDev() {
        return this.weightedSnapshot.getStdDev();
    }

    public void dump(OutputStream output) {
        this.weightedSnapshot.dump(output);
    }

    static class WeightedSampleWithExemplar {
        private final long value;
        private final double weight;
        private final @Nullable Object exemplarMetadata;

        WeightedSampleWithExemplar(long value, double weight, @Nullable Object exemplarMetadata) {
            this.value = value;
            this.weight = weight;
            this.exemplarMetadata = exemplarMetadata;
        }

        long value() {
            return this.value;
        }

        double weight() {
            return this.weight;
        }

        @Nullable Object exemplarMetadata() {
            return this.exemplarMetadata;
        }
    }
}

