/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.registry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Ordering;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

final class TagMap
implements SortedMap<String, String> {
    static final TagMap EMPTY = new TagMap(new String[0]);
    private final String[] values;

    static TagMap of(Map<String, String> data) {
        SortedMap sortedMap;
        if (data instanceof TagMap) {
            return (TagMap)data;
        }
        if (data.isEmpty()) {
            return EMPTY;
        }
        if (data instanceof SortedMap && TagMap.isNaturalOrder((sortedMap = (SortedMap)data).comparator())) {
            return new TagMap(TagMap.toArrayFromNaturalSortedMap(sortedMap));
        }
        return new TagMap(TagMap.toArray(data));
    }

    private TagMap(String[] values) {
        this.values = values;
    }

    @VisibleForTesting
    static boolean isNaturalOrder(@Nullable Comparator<?> comparator) {
        return comparator == null || Objects.equals(comparator, Comparator.naturalOrder()) || Objects.equals(comparator, Ordering.natural());
    }

    private static String[] toArrayFromNaturalSortedMap(SortedMap<String, String> data) {
        int size = data.size();
        String[] values = new String[size * 2];
        int index = 0;
        for (Map.Entry<String, String> entry : data.entrySet()) {
            values[index++] = entry.getKey();
            values[index++] = entry.getValue();
        }
        return values;
    }

    private static String[] toArray(Map<String, String> data) {
        int size = data.size();
        String[] values = new String[size * 2];
        Object[] keys = new String[size];
        int keysIndex = 0;
        for (Map.Entry<String, String> entry : data.entrySet()) {
            keys[keysIndex++] = entry.getKey();
        }
        Arrays.sort(keys);
        for (int i = 0; i < keys.length; ++i) {
            Object key;
            int valuesIndex = 2 * i;
            values[valuesIndex] = key = keys[i];
            values[valuesIndex + 1] = data.get(key);
        }
        return values;
    }

    TagMap withEntry(String key, String value) {
        int newPosition;
        String[] local = this.values;
        for (newPosition = 0; newPosition < local.length; newPosition += 2) {
            String current = local[newPosition];
            int comparisonResult = current.compareTo(key);
            if (comparisonResult == 0) {
                if (Objects.equals(local[newPosition + 1], value)) {
                    return this;
                }
                String[] newArray = (String[])local.clone();
                newArray[newPosition + 1] = value;
                return new TagMap(newArray);
            }
            if (comparisonResult > 0) break;
        }
        String[] newArray = new String[local.length + 2];
        System.arraycopy(local, 0, newArray, 0, newPosition);
        newArray[newPosition] = key;
        newArray[newPosition + 1] = value;
        System.arraycopy(local, newPosition, newArray, newPosition + 2, local.length - newPosition);
        return new TagMap(newArray);
    }

    @Override
    public @Nullable String get(Object key) {
        int idx = this.indexOfKey(key);
        return idx >= 0 ? this.values[idx + 1] : null;
    }

    private int indexOfKey(Object key) {
        String[] local = this.values;
        for (int i = 0; i < local.length; i += 2) {
            if (!Objects.equals(key, local[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super String> action) {
        String[] local = this.values;
        for (int i = 0; i < local.length; i += 2) {
            action.accept(local[i], local[i + 1]);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("{");
        String[] local = this.values;
        for (int i = 0; i < local.length; i += 2) {
            String key = local[i];
            String value = local[i + 1];
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(key);
            sb.append('=');
            sb.append(value);
        }
        return sb.append('}').toString();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TagMap) {
            return Arrays.equals(this.values, ((TagMap)other).values);
        }
        if (!(other instanceof Map)) {
            return false;
        }
        Map otherMap = (Map)other;
        if (otherMap.size() != this.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; i += 2) {
            String value = this.values[i + 1];
            String key = this.values[i];
            if (Objects.equals(value, otherMap.get(key))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode = 0;
        for (int i = 0; i < this.values.length; i += 2) {
            hashCode += Objects.hashCode(this.values[i]) ^ Objects.hashCode(this.values[i + 1]);
        }
        return hashCode;
    }

    @Override
    public @Nullable Comparator<? super String> comparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public SortedMap<String, String> subMap(String fromKey, String toKey) {
        String key;
        int i;
        int beginIndex = 0;
        for (i = 0; i < this.values.length; i += 2) {
            key = this.values[i];
            if (key.compareTo(fromKey) < 0) continue;
            beginIndex = i;
            break;
        }
        for (i = this.values.length - 2; i >= beginIndex; i -= 2) {
            key = this.values[i];
            if (key.compareTo(toKey) >= 0) continue;
            return new TagMap(Arrays.copyOfRange(this.values, beginIndex, i + 2));
        }
        return EMPTY;
    }

    @Override
    public SortedMap<String, String> headMap(String toKey) {
        for (int i = this.values.length - 2; i >= 0; i -= 2) {
            String key = this.values[i];
            if (key.compareTo(toKey) >= 0) continue;
            return new TagMap(Arrays.copyOfRange(this.values, 0, i + 2));
        }
        return EMPTY;
    }

    @Override
    public SortedMap<String, String> tailMap(String fromKey) {
        for (int i = 0; i < this.values.length; i += 2) {
            String key = this.values[i];
            if (key.compareTo(fromKey) < 0) continue;
            return new TagMap(Arrays.copyOfRange(this.values, i, this.values.length));
        }
        return EMPTY;
    }

    @Override
    public @Nullable String firstKey() {
        String[] local = this.values;
        if (local.length == 0) {
            throw new NoSuchElementException();
        }
        return local[0];
    }

    @Override
    public @Nullable String lastKey() {
        String[] local = this.values;
        if (local.length == 0) {
            throw new NoSuchElementException();
        }
        return local[local.length - 2];
    }

    @Override
    public int size() {
        return this.values.length / 2;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.indexOfKey(key) >= 0;
    }

    @Override
    public boolean containsValue(Object value) {
        String[] local = this.values;
        for (int i = 1; i < local.length; i += 2) {
            if (!Objects.equals(value, local[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public @Nullable String put(String _key, String _value) {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public void putAll(@NonNull Map<? extends String, ? extends String> _map) {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public @Nullable String remove(Object _key) {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("immutable");
    }

    @Override
    public @NonNull Set<String> keySet() {
        String[] local = this.values;
        LinkedHashSet<String> set = new LinkedHashSet<String>(local.length / 2);
        for (int i = 0; i < local.length; i += 2) {
            set.add(local[i]);
        }
        return Collections.unmodifiableSet(set);
    }

    @Override
    public @NonNull Collection<String> values() {
        String[] local = this.values;
        ArrayList<String> list = new ArrayList<String>(local.length / 2);
        for (int i = 1; i < local.length; i += 2) {
            list.add(local[i]);
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public @NonNull Set<Map.Entry<String, String>> entrySet() {
        return new TagMapEntrySet(this.values);
    }

    private static final class TagMapEntrySet
    implements Set<Map.Entry<String, String>> {
        private final String[] values;

        TagMapEntrySet(String[] values) {
            this.values = values;
        }

        @Override
        public int size() {
            return this.values.length / 2;
        }

        @Override
        public boolean isEmpty() {
            return this.values.length == 0;
        }

        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                for (int i = 0; i < this.values.length; i += 2) {
                    if (!Objects.equals(entry.getKey(), this.values[i]) || !Objects.equals(entry.getValue(), this.values[i + 1])) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public @NonNull Iterator<Map.Entry<String, String>> iterator() {
            return new TagMapEntrySetIterator(this.values);
        }

        @Override
        public @NonNull Object[] toArray() {
            String[] local = this.values;
            Object[] result = new Object[local.length / 2];
            for (int i = 0; i < local.length; i += 2) {
                result[i / 2] = new TagEntry(local[i], local[i + 1]);
            }
            return result;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            String[] local = this.values;
            int resultLength = local.length / 2;
            Object[] result = resultLength > array.length ? (Object[])Array.newInstance(array.getClass().getComponentType(), resultLength) : array;
            for (int i = 0; i < local.length; i += 2) {
                result[i / 2] = new TagEntry(local[i], local[i + 1]);
            }
            Arrays.fill(result, resultLength, array.length, null);
            return result;
        }

        @Override
        public boolean add(Map.Entry<String, String> _stringStringEntry) {
            throw new UnsupportedOperationException("immutable");
        }

        @Override
        public boolean remove(Object _object) {
            throw new UnsupportedOperationException("immutable");
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            for (Object object : collection) {
                if (this.contains(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean addAll(@NonNull Collection<? extends Map.Entry<String, String>> _collection) {
            throw new UnsupportedOperationException("immutable");
        }

        @Override
        public boolean retainAll(@NonNull Collection<?> _collection) {
            throw new UnsupportedOperationException("immutable");
        }

        @Override
        public boolean removeAll(@NonNull Collection<?> _collection) {
            throw new UnsupportedOperationException("immutable");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("immutable");
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Set)) {
                return false;
            }
            if (other instanceof TagMapEntrySet) {
                return Arrays.equals(this.values, ((TagMapEntrySet)other).values);
            }
            Set otherSet = (Set)other;
            return this.size() == otherSet.size() && this.containsAll(otherSet) && otherSet.containsAll(this);
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (int i = 0; i < this.values.length; i += 2) {
                hashCode += Objects.hashCode(this.values[i]) ^ Objects.hashCode(this.values[i + 1]);
            }
            return hashCode;
        }

        public String toString() {
            return "TagMapEntrySet{" + Arrays.toString(this.values) + "}";
        }
    }

    private static final class TagEntry
    implements Map.Entry<String, String> {
        private final String key;
        private final String value;

        TagEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public String setValue(String _value) {
            throw new UnsupportedOperationException("immutable");
        }

        public String toString() {
            return "{" + this.key + "=" + this.value + "}";
        }

        @Override
        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return Objects.equals(entry.getKey(), this.key) && Objects.equals(entry.getValue(), this.value);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.key) ^ Objects.hashCode(this.value);
        }
    }

    private static final class TagMapEntrySetIterator
    implements Iterator<Map.Entry<String, String>> {
        private final String[] values;
        private int current = -2;

        TagMapEntrySetIterator(String[] values) {
            this.values = values;
        }

        @Override
        public boolean hasNext() {
            return this.current + 2 < this.values.length;
        }

        @Override
        public Map.Entry<String, String> next() {
            if (this.hasNext()) {
                this.current += 2;
                return new TagEntry(this.values[this.current], this.values[this.current + 1]);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("immutable");
        }
    }
}

