/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Meter;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class TlsMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.97.0";
    private final TaggedMetricRegistry registry;

    private TlsMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static TlsMetrics of(TaggedMetricRegistry registry) {
        return new TlsMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    HandshakeBuilderContextStage handshake() {
        return new HandshakeBuilder();
    }

    public String toString() {
        return "TlsMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class HandshakeBuilder
    implements HandshakeBuilderContextStage,
    HandshakeBuilderCipherStage,
    HandshakeBuilderProtocolStage,
    HandshakeBuildStage {
        private String context;
        private String cipher;
        private String protocol;

        private HandshakeBuilder() {
        }

        @Override
        public HandshakeBuilder context(@Safe String context) {
            Preconditions.checkState((this.context == null ? 1 : 0) != 0, (String)"context is already set");
            this.context = (String)Preconditions.checkNotNull((Object)context, (String)"context is required");
            return this;
        }

        @Override
        public HandshakeBuilder cipher(@Safe String cipher) {
            Preconditions.checkState((this.cipher == null ? 1 : 0) != 0, (String)"cipher is already set");
            this.cipher = (String)Preconditions.checkNotNull((Object)cipher, (String)"cipher is required");
            return this;
        }

        @Override
        public HandshakeBuilder protocol(@Safe String protocol) {
            Preconditions.checkState((this.protocol == null ? 1 : 0) != 0, (String)"protocol is already set");
            this.protocol = (String)Preconditions.checkNotNull((Object)protocol, (String)"protocol is required");
            return this;
        }

        @Override
        public Meter build() {
            return TlsMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("tls.handshake").putSafeTags("context", this.context).putSafeTags("cipher", this.cipher).putSafeTags("protocol", this.protocol).putSafeTags("libraryName", TlsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", TlsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface HandshakeBuilderProtocolStage {
        @CheckReturnValue
        public HandshakeBuildStage protocol(@Safe String var1);
    }

    static interface HandshakeBuilderCipherStage {
        @CheckReturnValue
        public HandshakeBuilderProtocolStage cipher(@Safe String var1);
    }

    static interface HandshakeBuilderContextStage {
        @CheckReturnValue
        public HandshakeBuilderCipherStage context(@Safe String var1);
    }

    static interface HandshakeBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

