/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.palantir.tritium.metrics.ExecutorMetrics;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jspecify.annotations.Nullable;

final class TaggedMetricsExecutorService
extends AbstractExecutorService {
    private static final long QUEUED_DURATION_MINIMUM_THRESHOLD_NANOS = 250000000L;
    private final ExecutorService delegate;
    private final String name;
    private final Meter submitted;
    private final Counter running;
    private final Timer duration;
    private final @Nullable Timer queuedDuration;

    TaggedMetricsExecutorService(ExecutorService delegate, ExecutorMetrics metrics, String name, boolean reportQueuedDuration) {
        this.delegate = delegate;
        this.name = name;
        this.submitted = metrics.submitted(name);
        this.running = metrics.running(name);
        this.duration = metrics.duration(name);
        this.queuedDuration = reportQueuedDuration ? metrics.queuedDuration(name) : null;
    }

    @Override
    public void execute(Runnable task) {
        this.delegate.execute(new TaggedMetricsRunnable(task));
        this.submitted.mark();
    }

    @Override
    public Future<?> submit(Runnable task) {
        Future<?> future = this.delegate.submit(new TaggedMetricsRunnable(task));
        this.submitted.mark();
        return future;
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        Future<T> future = this.delegate.submit(new TaggedMetricsRunnable(task), result);
        this.submitted.mark();
        return future;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        Future<T> future = this.delegate.submit(new TaggedMetricsCallable<T>(task));
        this.submitted.mark();
        return future;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    public String toString() {
        return "TaggedMetricsExecutorService{name=" + this.name + ", delegate='" + String.valueOf(this.delegate) + "'}";
    }

    private final class TaggedMetricsRunnable
    implements Runnable {
        private final Runnable task;
        private final long created;

        TaggedMetricsRunnable(Runnable task) {
            this.created = TaggedMetricsExecutorService.this.queuedDuration == null ? 0L : System.nanoTime();
            this.task = task;
        }

        @Override
        public void run() {
            this.stopQueueTimer();
            TaggedMetricsExecutorService.this.running.inc();
            long startNanos = System.nanoTime();
            try {
                this.task.run();
            }
            finally {
                TaggedMetricsExecutorService.this.duration.update(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                TaggedMetricsExecutorService.this.running.dec();
            }
        }

        void stopQueueTimer() {
            long queuedDurationNanos;
            Timer queuedDurationTimer = TaggedMetricsExecutorService.this.queuedDuration;
            if (queuedDurationTimer != null && (queuedDurationNanos = System.nanoTime() - this.created) > 250000000L) {
                queuedDurationTimer.update(queuedDurationNanos, TimeUnit.NANOSECONDS);
            }
        }
    }

    private final class TaggedMetricsCallable<T>
    implements Callable<T> {
        private final Callable<T> task;
        private final long created;

        TaggedMetricsCallable(Callable<T> task) {
            this.created = TaggedMetricsExecutorService.this.queuedDuration == null ? 0L : System.nanoTime();
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            this.stopQueueTimer();
            TaggedMetricsExecutorService.this.running.inc();
            long startNanos = System.nanoTime();
            try {
                T t = this.task.call();
                return t;
            }
            finally {
                TaggedMetricsExecutorService.this.duration.update(System.nanoTime() - startNanos, TimeUnit.NANOSECONDS);
                TaggedMetricsExecutorService.this.running.dec();
            }
        }

        void stopQueueTimer() {
            long queuedDurationNanos;
            Timer queuedDurationTimer = TaggedMetricsExecutorService.this.queuedDuration;
            if (queuedDurationTimer != null && (queuedDurationNanos = System.nanoTime() - this.created) > 250000000L) {
                queuedDurationTimer.update(queuedDurationNanos, TimeUnit.NANOSECONDS);
            }
        }
    }
}

