/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class JvmMemoryPoolsMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.97.0";
    private final TaggedMetricRegistry registry;

    private JvmMemoryPoolsMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static JvmMemoryPoolsMetrics of(TaggedMetricRegistry registry) {
        return new JvmMemoryPoolsMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    MaxBuilderMemoryPoolStage max() {
        return new MaxBuilder();
    }

    @CheckReturnValue
    UsedBuilderMemoryPoolStage used() {
        return new UsedBuilder();
    }

    @CheckReturnValue
    CommittedBuilderMemoryPoolStage committed() {
        return new CommittedBuilder();
    }

    @CheckReturnValue
    InitBuilderMemoryPoolStage init() {
        return new InitBuilder();
    }

    @CheckReturnValue
    UsageBuilderMemoryPoolStage usage() {
        return new UsageBuilder();
    }

    @CheckReturnValue
    UsedAfterGcBuilderMemoryPoolStage usedAfterGc() {
        return new UsedAfterGcBuilder();
    }

    public String toString() {
        return "JvmMemoryPoolsMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class MaxBuilder
    implements MaxBuilderMemoryPoolStage,
    MaxBuildStage {
        private String memoryPool;

        private MaxBuilder() {
        }

        @Override
        public MaxBuilder memoryPool(@Safe String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.max").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmMemoryPoolsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class UsedBuilder
    implements UsedBuilderMemoryPoolStage,
    UsedBuildStage {
        private String memoryPool;

        private UsedBuilder() {
        }

        @Override
        public UsedBuilder memoryPool(@Safe String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.used").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmMemoryPoolsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class CommittedBuilder
    implements CommittedBuilderMemoryPoolStage,
    CommittedBuildStage {
        private String memoryPool;

        private CommittedBuilder() {
        }

        @Override
        public CommittedBuilder memoryPool(@Safe String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.committed").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmMemoryPoolsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class InitBuilder
    implements InitBuilderMemoryPoolStage,
    InitBuildStage {
        private String memoryPool;

        private InitBuilder() {
        }

        @Override
        public InitBuilder memoryPool(@Safe String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.init").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmMemoryPoolsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class UsageBuilder
    implements UsageBuilderMemoryPoolStage,
    UsageBuildStage {
        private String memoryPool;

        private UsageBuilder() {
        }

        @Override
        public UsageBuilder memoryPool(@Safe String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.usage").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmMemoryPoolsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class UsedAfterGcBuilder
    implements UsedAfterGcBuilderMemoryPoolStage,
    UsedAfterGcBuildStage {
        private String memoryPool;

        private UsedAfterGcBuilder() {
        }

        @Override
        public UsedAfterGcBuilder memoryPool(@Safe String memoryPool) {
            Preconditions.checkState((this.memoryPool == null ? 1 : 0) != 0, (String)"memoryPool is already set");
            this.memoryPool = (String)Preconditions.checkNotNull((Object)memoryPool, (String)"memoryPool is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmMemoryPoolsMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.memory.pools.used-after-gc").putSafeTags("memoryPool", this.memoryPool).putSafeTags("libraryName", JvmMemoryPoolsMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmMemoryPoolsMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface UsedAfterGcBuilderMemoryPoolStage {
        @CheckReturnValue
        public UsedAfterGcBuildStage memoryPool(@Safe String var1);
    }

    static interface UsedAfterGcBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface UsageBuilderMemoryPoolStage {
        @CheckReturnValue
        public UsageBuildStage memoryPool(@Safe String var1);
    }

    static interface UsageBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface InitBuilderMemoryPoolStage {
        @CheckReturnValue
        public InitBuildStage memoryPool(@Safe String var1);
    }

    static interface InitBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface CommittedBuilderMemoryPoolStage {
        @CheckReturnValue
        public CommittedBuildStage memoryPool(@Safe String var1);
    }

    static interface CommittedBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface UsedBuilderMemoryPoolStage {
        @CheckReturnValue
        public UsedBuildStage memoryPool(@Safe String var1);
    }

    static interface UsedBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface MaxBuilderMemoryPoolStage {
        @CheckReturnValue
        public MaxBuildStage memoryPool(@Safe String var1);
    }

    static interface MaxBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

