/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheStats;
import com.google.common.collect.ImmutableMap;
import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.metrics.InternalCacheMetrics;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

final class CacheMetricSet
implements MetricSet {
    private final Cache<?, ?> cache;
    private final String cacheName;

    private CacheMetricSet(Cache<?, ?> cache, String cacheName) {
        this.cache = (Cache)Preconditions.checkNotNull(cache, (String)"cache");
        this.cacheName = (String)Preconditions.checkNotNull((Object)cacheName, (String)"cacheName");
        Preconditions.checkArgument((!cacheName.trim().isEmpty() ? 1 : 0) != 0, (String)"Cache name cannot be blank or empty");
    }

    static CacheMetricSet create(Cache<?, ?> cache, String cacheName) {
        return new CacheMetricSet(cache, cacheName);
    }

    public Map<String, Metric> getMetrics() {
        return ImmutableMap.copyOf(InternalCacheMetrics.createMetrics(GuavaStats.create(this.cache, 1L, TimeUnit.SECONDS), metricName -> this.cacheName + "." + metricName));
    }

    static class GuavaStats
    implements InternalCacheMetrics.Stats {
        private final Cache<?, ?> cache;
        private final java.util.function.Supplier<CacheStats> stats;

        @VisibleForTesting
        GuavaStats(Cache<?, ?> cache, java.util.function.Supplier<CacheStats> stats) {
            this.cache = cache;
            this.stats = stats;
        }

        static InternalCacheMetrics.Stats create(Cache<?, ?> cache, long duration, TimeUnit timeUnit) {
            Supplier statsSupplier = Suppliers.memoizeWithExpiration(() -> cache.stats(), (long)duration, (TimeUnit)timeUnit);
            return new GuavaStats(cache, (java.util.function.Supplier<CacheStats>)statsSupplier);
        }

        private CacheStats stats() {
            return this.stats.get();
        }

        @Override
        public Gauge<Long> estimatedSize() {
            return () -> this.cache.size();
        }

        @Override
        public Optional<Gauge<Long>> weightedSize() {
            return Optional.empty();
        }

        @Override
        public Optional<Gauge<Long>> maximumSize() {
            return Optional.empty();
        }

        @Override
        public Gauge<Long> requestCount() {
            return () -> this.stats().requestCount();
        }

        @Override
        public Gauge<Long> hitCount() {
            return () -> this.stats().hitCount();
        }

        @Override
        public Gauge<Long> missCount() {
            return () -> this.stats().missCount();
        }

        @Override
        public Gauge<Long> evictionCount() {
            return () -> this.stats().evictionCount();
        }

        @Override
        public Gauge<Long> loadSuccessCount() {
            return () -> this.stats().loadSuccessCount();
        }

        @Override
        public Gauge<Long> loadFailureCount() {
            return () -> this.stats().loadExceptionCount();
        }

        @Override
        public Gauge<Double> loadAverageMillis() {
            return () -> this.stats().averageLoadPenalty() / 1000000.0;
        }
    }
}

