/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event.metrics;

import com.codahale.metrics.Timer;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class InstrumentationMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.97.0";
    private final TaggedMetricRegistry registry;

    private InstrumentationMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static InstrumentationMetrics of(TaggedMetricRegistry registry) {
        return new InstrumentationMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    InvocationBuilderServiceNameStage invocation() {
        return new InvocationBuilder();
    }

    public String toString() {
        return "InstrumentationMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class InvocationBuilder
    implements InvocationBuilderServiceNameStage,
    InvocationBuilderEndpointStage,
    InvocationBuilderResultStage,
    InvocationBuildStage {
        private String serviceName;
        private String endpoint;
        private Invocation_Result result;

        private InvocationBuilder() {
        }

        @Override
        public InvocationBuilder serviceName(@Safe String serviceName) {
            Preconditions.checkState((this.serviceName == null ? 1 : 0) != 0, (String)"service-name is already set");
            this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"service-name is required");
            return this;
        }

        @Override
        public InvocationBuilder endpoint(@Safe String endpoint) {
            Preconditions.checkState((this.endpoint == null ? 1 : 0) != 0, (String)"endpoint is already set");
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (String)"endpoint is required");
            return this;
        }

        @Override
        public InvocationBuilder result(@Safe Invocation_Result result) {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0, (String)"result is already set");
            this.result = (Invocation_Result)((Object)Preconditions.checkNotNull((Object)((Object)result), (String)"result is required"));
            return this;
        }

        @Override
        public Timer build() {
            return InstrumentationMetrics.this.registry.timer(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("instrumentation.invocation").putSafeTags("service-name", this.serviceName).putSafeTags("endpoint", this.endpoint).putSafeTags("result", this.result.getValue()).putSafeTags("libraryName", InstrumentationMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", InstrumentationMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface InvocationBuilderResultStage {
        @CheckReturnValue
        public InvocationBuildStage result(@Safe Invocation_Result var1);
    }

    static interface InvocationBuilderEndpointStage {
        @CheckReturnValue
        public InvocationBuilderResultStage endpoint(@Safe String var1);
    }

    static interface InvocationBuilderServiceNameStage {
        @CheckReturnValue
        public InvocationBuilderEndpointStage serviceName(@Safe String var1);
    }

    static interface InvocationBuildStage {
        @CheckReturnValue
        public Timer build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static enum Invocation_Result {
        SUCCESS("success"),
        FAILURE("failure");

        private final String value;

        private Invocation_Result(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }
}

