/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class JvmGcMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.102.0";
    private static final MetricName finalizerQueueSizeMetricName = MetricName.builder().safeName("jvm.gc.finalizer.queue.size").putSafeTags("libraryName", "tritium").putSafeTags("libraryVersion", "0.102.0").putSafeTags("javaVersion", JAVA_VERSION).build();
    private final TaggedMetricRegistry registry;

    private JvmGcMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static JvmGcMetrics of(TaggedMetricRegistry registry) {
        return new JvmGcMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    CountBuilderCollectorStage count() {
        return new CountBuilder();
    }

    @CheckReturnValue
    TimeBuilderCollectorStage time() {
        return new TimeBuilder();
    }

    void finalizerQueueSize(Gauge<? extends Number> gauge) {
        this.registry.registerWithReplacement(JvmGcMetrics.finalizerQueueSizeMetricName(), gauge);
    }

    static MetricName finalizerQueueSizeMetricName() {
        return finalizerQueueSizeMetricName;
    }

    public String toString() {
        return "JvmGcMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class CountBuilder
    implements CountBuilderCollectorStage,
    CountBuildStage {
        private String collector;

        private CountBuilder() {
        }

        @Override
        public CountBuilder collector(@Safe String collector) {
            Preconditions.checkState((this.collector == null ? 1 : 0) != 0, (String)"collector is already set");
            this.collector = (String)Preconditions.checkNotNull((Object)collector, (String)"collector is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmGcMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.gc.count").putSafeTags("collector", this.collector).putSafeTags("libraryName", JvmGcMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmGcMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class TimeBuilder
    implements TimeBuilderCollectorStage,
    TimeBuildStage {
        private String collector;

        private TimeBuilder() {
        }

        @Override
        public TimeBuilder collector(@Safe String collector) {
            Preconditions.checkState((this.collector == null ? 1 : 0) != 0, (String)"collector is already set");
            this.collector = (String)Preconditions.checkNotNull((Object)collector, (String)"collector is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            JvmGcMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("jvm.gc.time").putSafeTags("collector", this.collector).putSafeTags("libraryName", JvmGcMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", JvmGcMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface TimeBuilderCollectorStage {
        @CheckReturnValue
        public TimeBuildStage collector(@Safe String var1);
    }

    static interface TimeBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface CountBuilderCollectorStage {
        @CheckReturnValue
        public CountBuildStage collector(@Safe String var1);
    }

    static interface CountBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }
}

