/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Gauge;
import com.google.common.base.CharMatcher;
import com.palantir.tritium.metrics.JvmGcMetrics;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;

final class GarbageCollectorMetrics {
    static void register(TaggedMetricRegistry metrics) {
        JvmGcMetrics gcMetrics = JvmGcMetrics.of(metrics);
        for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
            String collector = GarbageCollectorMetrics.canonicalName(gc.getName());
            gcMetrics.count().collector(collector).build((Gauge<? extends Number>)((Gauge)gc::getCollectionCount));
            gcMetrics.time().collector(collector).build((Gauge<? extends Number>)((Gauge)gc::getCollectionTime));
        }
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        gcMetrics.finalizerQueueSize((Gauge<? extends Number>)((Gauge)memoryBean::getObjectPendingFinalizationCount));
    }

    private static String canonicalName(String collectorName) {
        return CharMatcher.whitespace().replaceFrom((CharSequence)collectorName, (CharSequence)"-");
    }

    private GarbageCollectorMetrics() {
    }
}

