/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class ExecutorMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.102.0";
    private final TaggedMetricRegistry registry;

    private ExecutorMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static ExecutorMetrics of(TaggedMetricRegistry registry) {
        return new ExecutorMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    Meter submitted(@Safe String executor) {
        return this.registry.meter(ExecutorMetrics.submittedMetricName(executor));
    }

    static MetricName submittedMetricName(@Safe String executor) {
        return MetricName.builder().safeName("executor.submitted").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    Counter running(@Safe String executor) {
        return this.registry.counter(ExecutorMetrics.runningMetricName(executor));
    }

    static MetricName runningMetricName(@Safe String executor) {
        return MetricName.builder().safeName("executor.running").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    Timer duration(@Safe String executor) {
        return this.registry.timer(ExecutorMetrics.durationMetricName(executor));
    }

    static MetricName durationMetricName(@Safe String executor) {
        return MetricName.builder().safeName("executor.duration").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    Timer queuedDuration(@Safe String executor) {
        return this.registry.timer(ExecutorMetrics.queuedDurationMetricName(executor));
    }

    static MetricName queuedDurationMetricName(@Safe String executor) {
        return MetricName.builder().safeName("executor.queued-duration").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    Counter scheduledOverrun(@Safe String executor) {
        return this.registry.counter(ExecutorMetrics.scheduledOverrunMetricName(executor));
    }

    static MetricName scheduledOverrunMetricName(@Safe String executor) {
        return MetricName.builder().safeName("executor.scheduled.overrun").putSafeTags("executor", executor).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    @CheckReturnValue
    ThreadsCreatedBuilderExecutorStage threadsCreated() {
        return new ThreadsCreatedBuilder();
    }

    @CheckReturnValue
    ThreadsRunningBuilderExecutorStage threadsRunning() {
        return new ThreadsRunningBuilder();
    }

    public String toString() {
        return "ExecutorMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class ThreadsCreatedBuilder
    implements ThreadsCreatedBuilderExecutorStage,
    ThreadsCreatedBuilderThreadTypeStage,
    ThreadsCreatedBuildStage {
        private String executor;
        private ThreadsCreated_ThreadType threadType;

        private ThreadsCreatedBuilder() {
        }

        @Override
        public ThreadsCreatedBuilder executor(@Safe String executor) {
            Preconditions.checkState((this.executor == null ? 1 : 0) != 0, (String)"executor is already set");
            this.executor = (String)Preconditions.checkNotNull((Object)executor, (String)"executor is required");
            return this;
        }

        @Override
        public ThreadsCreatedBuilder threadType(@Safe ThreadsCreated_ThreadType threadType) {
            Preconditions.checkState((this.threadType == null ? 1 : 0) != 0, (String)"thread-type is already set");
            this.threadType = (ThreadsCreated_ThreadType)((Object)Preconditions.checkNotNull((Object)((Object)threadType), (String)"thread-type is required"));
            return this;
        }

        @Override
        public Meter build() {
            return ExecutorMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("executor.threads.created").putSafeTags("executor", this.executor).putSafeTags("thread-type", this.threadType.getValue()).putSafeTags("libraryName", ExecutorMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", ExecutorMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class ThreadsRunningBuilder
    implements ThreadsRunningBuilderExecutorStage,
    ThreadsRunningBuilderThreadTypeStage,
    ThreadsRunningBuildStage {
        private String executor;
        private ThreadsRunning_ThreadType threadType;

        private ThreadsRunningBuilder() {
        }

        @Override
        public ThreadsRunningBuilder executor(@Safe String executor) {
            Preconditions.checkState((this.executor == null ? 1 : 0) != 0, (String)"executor is already set");
            this.executor = (String)Preconditions.checkNotNull((Object)executor, (String)"executor is required");
            return this;
        }

        @Override
        public ThreadsRunningBuilder threadType(@Safe ThreadsRunning_ThreadType threadType) {
            Preconditions.checkState((this.threadType == null ? 1 : 0) != 0, (String)"thread-type is already set");
            this.threadType = (ThreadsRunning_ThreadType)((Object)Preconditions.checkNotNull((Object)((Object)threadType), (String)"thread-type is required"));
            return this;
        }

        @Override
        public Counter build() {
            return ExecutorMetrics.this.registry.counter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("executor.threads.running").putSafeTags("executor", this.executor).putSafeTags("thread-type", this.threadType.getValue()).putSafeTags("libraryName", ExecutorMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", ExecutorMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface ThreadsRunningBuilderThreadTypeStage {
        @CheckReturnValue
        public ThreadsRunningBuildStage threadType(@Safe ThreadsRunning_ThreadType var1);
    }

    static interface ThreadsRunningBuilderExecutorStage {
        @CheckReturnValue
        public ThreadsRunningBuilderThreadTypeStage executor(@Safe String var1);
    }

    static interface ThreadsRunningBuildStage {
        @CheckReturnValue
        public Counter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static enum ThreadsRunning_ThreadType {
        PLATFORM("platform"),
        VIRTUAL("virtual");

        private final String value;

        private ThreadsRunning_ThreadType(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }

    static interface ThreadsCreatedBuilderThreadTypeStage {
        @CheckReturnValue
        public ThreadsCreatedBuildStage threadType(@Safe ThreadsCreated_ThreadType var1);
    }

    static interface ThreadsCreatedBuilderExecutorStage {
        @CheckReturnValue
        public ThreadsCreatedBuilderThreadTypeStage executor(@Safe String var1);
    }

    static interface ThreadsCreatedBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static enum ThreadsCreated_ThreadType {
        PLATFORM("platform"),
        VIRTUAL("virtual");

        private final String value;

        private ThreadsCreated_ThreadType(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }
}

