/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event.metrics;

import com.codahale.metrics.MetricRegistry;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.event.AbstractInvocationEventHandler;
import com.palantir.tritium.event.DefaultInvocationContext;
import com.palantir.tritium.event.InstrumentationProperties;
import com.palantir.tritium.event.InvocationContext;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class MetricsInvocationEventHandler
extends AbstractInvocationEventHandler<InvocationContext> {
    private static final String FAILURES = "failures";
    private final MetricRegistry metricRegistry;
    @Safe
    private final String serviceName;

    public MetricsInvocationEventHandler(MetricRegistry metricRegistry, @Safe String serviceName) {
        super(MetricsInvocationEventHandler.getEnabledSupplier(serviceName));
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry, (String)"metricRegistry");
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"serviceName");
    }

    public MetricsInvocationEventHandler(MetricRegistry metricRegistry, Class<?> _serviceClass, @Safe String serviceName, @Safe @Nullable String _globalGroupPrefix) {
        super(MetricsInvocationEventHandler.getEnabledSupplier(serviceName));
        this.metricRegistry = (MetricRegistry)Preconditions.checkNotNull((Object)metricRegistry, (String)"metricRegistry");
        this.serviceName = (String)Preconditions.checkNotNull((Object)serviceName, (String)"serviceName");
    }

    public MetricsInvocationEventHandler(MetricRegistry metricRegistry, Class<?> serviceClass, @Safe @Nullable String globalGroupPrefix) {
        this(metricRegistry, serviceClass, (String)Preconditions.checkNotNull((Object)serviceClass.getName()), globalGroupPrefix);
    }

    static BooleanSupplier getEnabledSupplier(String serviceName) {
        return InstrumentationProperties.getSystemPropertySupplier((String)serviceName);
    }

    public InvocationContext preInvocation(@NonNull Object instance, @NonNull Method method, @NonNull Object[] args) {
        return DefaultInvocationContext.of((Object)instance, (Method)method, (Object[])args);
    }

    public void onSuccess(@Nullable InvocationContext context, @Nullable Object _result) {
        this.debugIfNullContext(context);
        if (context != null) {
            this.updateTimer(context);
        }
    }

    public void onFailure(@Nullable InvocationContext context, @NonNull Throwable _cause) {
        this.markGlobalFailure();
        this.debugIfNullContext(context);
        if (context != null) {
            this.metricRegistry.meter(this.getBaseMetricName(context) + ".failures").mark();
        }
    }

    private void updateTimer(InvocationContext context) {
        long nanos = System.nanoTime() - context.getStartTimeNanos();
        this.metricRegistry.timer(this.getBaseMetricName(context)).update(nanos, TimeUnit.NANOSECONDS);
    }

    private String getBaseMetricName(InvocationContext context) {
        return this.serviceName + "." + context.getMethod().getName();
    }

    private void markGlobalFailure() {
        this.metricRegistry.meter(FAILURES).mark();
    }
}

