/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event;

import com.google.common.base.Strings;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMap;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.api.functions.BooleanSupplier;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public final class InstrumentationProperties {
    private static final SafeLogger log = SafeLoggerFactory.get(InstrumentationProperties.class);
    private static final String INSTRUMENT_PREFIX = "instrument";
    private static volatile Supplier<Map<String, String>> instrumentationProperties = InstrumentationProperties.createSupplier();

    private InstrumentationProperties() {
    }

    public static BooleanSupplier getSystemPropertySupplier(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (String)"name cannot be null or empty", (Arg)SafeArg.of((String)"name", (Object)name));
        boolean instrumentationEnabled = InstrumentationProperties.isGloballyEnabled() && InstrumentationProperties.isSpecificEnabled(name);
        return () -> instrumentationEnabled;
    }

    public static boolean isSpecificEnabled(String name) {
        return InstrumentationProperties.isSpecificEnabled(name, true);
    }

    public static boolean isSpecificEnabled(String name, boolean defaultValue) {
        Map<String, String> props = instrumentationProperties.get();
        if (props.isEmpty()) {
            return defaultValue;
        }
        String qualifiedValue = props.get("instrument." + name);
        if (qualifiedValue == null) {
            return defaultValue;
        }
        return "true".equalsIgnoreCase(qualifiedValue);
    }

    public static boolean isGloballyEnabled() {
        return !InstrumentationProperties.isGloballyDisabled();
    }

    private static boolean isGloballyDisabled() {
        return "false".equalsIgnoreCase(instrumentationProperties.get().get(INSTRUMENT_PREFIX));
    }

    public static void reload() {
        instrumentationProperties = InstrumentationProperties.createSupplier();
    }

    private static Supplier<Map<String, String>> createSupplier() {
        return Suppliers.memoizeWithExpiration(InstrumentationProperties::createInstrumentationSystemProperties, (long)1L, (TimeUnit)TimeUnit.MINUTES);
    }

    private static ImmutableMap<String, String> createInstrumentationSystemProperties() {
        Map clonedSystemProperties = (Map)System.getProperties().clone();
        ImmutableMap map = (ImmutableMap)clonedSystemProperties.entrySet().stream().filter(entry -> entry.getKey() instanceof String && entry.getValue() instanceof String && String.valueOf(entry.getKey()).startsWith(INSTRUMENT_PREFIX)).collect(ImmutableMap.toImmutableMap(entry -> String.valueOf(entry.getKey()), entry -> String.valueOf(entry.getValue())));
        if (log.isDebugEnabled()) {
            log.debug("Reloaded instrumentation properties", (Arg)UnsafeArg.of((String)"instrumentationProperties", (Object)map));
        }
        return map;
    }
}

