/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event;

import com.palantir.logsafe.Arg;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.UnsafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.api.event.InstrumentationFilter;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.event.InvocationEventHandler;
import java.lang.reflect.Method;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class Handlers {
    private static final SafeLogger log = SafeLoggerFactory.get(Handlers.class);

    public static InvocationContext disabled() {
        return DisabledHandlerSentinel.INSTANCE;
    }

    public static @Nullable InvocationContext pre(InvocationEventHandler<?> handler, InstrumentationFilter filter, Object instance, Method method, Object[] args) {
        try {
            return filter.shouldInstrument(instance, method, args) ? handler.preInvocation(instance, method, args) : DisabledHandlerSentinel.INSTANCE;
        }
        catch (Throwable t) {
            Handlers.logPreInvocationFailure(handler, instance, method, t);
            return null;
        }
    }

    public static @Nullable InvocationContext preWithEnabledCheck(InvocationEventHandler<?> handler, InstrumentationFilter filter, Object instance, Method method, Object[] args) {
        try {
            return handler.isEnabled() && filter.shouldInstrument(instance, method, args) ? handler.preInvocation(instance, method, args) : DisabledHandlerSentinel.INSTANCE;
        }
        catch (Throwable t) {
            Handlers.logPreInvocationFailure(handler, instance, method, t);
            return null;
        }
    }

    private static void logPreInvocationFailure(InvocationEventHandler<? extends InvocationContext> handler, Object instance, Method method, Throwable throwable) {
        if (log.isWarnEnabled()) {
            log.warn("Exception handling preInvocation: invocation threw", (Arg)UnsafeArg.of((String)"handler", handler), (Arg)SafeArg.of((String)"class", (Object)method.getDeclaringClass().getCanonicalName()), (Arg)SafeArg.of((String)"method", (Object)method.getName()), (Arg)UnsafeArg.of((String)"instance", (Object)Objects.toString(instance)), throwable);
        }
    }

    public static void onSuccess(InvocationEventHandler<?> handler, @Nullable InvocationContext context) {
        Handlers.onSuccess(handler, context, null);
    }

    public static void onSuccess(InvocationEventHandler<?> handler, @Nullable InvocationContext context, @Nullable Object result) {
        if (context != DisabledHandlerSentinel.INSTANCE) {
            try {
                handler.onSuccess(context, result);
            }
            catch (Throwable t) {
                Handlers.logOnSuccessFailure(handler, context, result, t);
            }
        }
    }

    private static void logOnSuccessFailure(InvocationEventHandler<?> handler, @Nullable InvocationContext context, @Nullable Object result, Throwable throwable) {
        if (log.isWarnEnabled()) {
            log.warn("Exception in onSuccess", (Arg)UnsafeArg.of((String)"handler", handler), (Arg)UnsafeArg.of((String)"context", (Object)context), (Arg)SafeArg.of((String)"result", (Object)(result == null ? "null" : result.getClass().getSimpleName())), throwable);
        }
    }

    public static void onFailure(InvocationEventHandler<?> handler, @Nullable InvocationContext context, Throwable thrown) {
        if (context != DisabledHandlerSentinel.INSTANCE) {
            try {
                handler.onFailure(context, thrown);
            }
            catch (Throwable t) {
                Handlers.logOnFailureFailure(handler, context, thrown, t);
            }
        }
    }

    private static void logOnFailureFailure(InvocationEventHandler<?> handler, @Nullable InvocationContext context, Throwable thrown, Throwable throwable) {
        if (log.isWarnEnabled()) {
            log.warn("Exception in onFailure", (Arg)UnsafeArg.of((String)"handler", handler), (Arg)UnsafeArg.of((String)"context", (Object)context), (Arg)SafeArg.of((String)"result", (Object)(thrown == null ? "null" : thrown.getClass().getSimpleName())), throwable);
        }
    }

    private Handlers() {
    }

    private static enum DisabledHandlerSentinel implements InvocationContext
    {
        INSTANCE;


        public long getStartTimeNanos() {
            throw DisabledHandlerSentinel.fail();
        }

        public Object getInstance() {
            throw DisabledHandlerSentinel.fail();
        }

        public Method getMethod() {
            throw DisabledHandlerSentinel.fail();
        }

        public Object[] getArgs() {
            throw DisabledHandlerSentinel.fail();
        }

        private static RuntimeException fail() {
            throw new UnsupportedOperationException("methods should not be invoked");
        }
    }
}

