/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event;

import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.event.InvocationContext;
import java.lang.reflect.Method;
import org.jspecify.annotations.Nullable;

public class DefaultInvocationContext
implements InvocationContext {
    private static final Object[] NO_ARGS = new Object[0];
    private final long startTimeNanos;
    private final Object instance;
    private final Method method;
    private final Object[] args;

    protected DefaultInvocationContext(long startTimeNanos, Object instance, Method method, @Nullable Object[] args) {
        this.startTimeNanos = startTimeNanos;
        this.instance = instance;
        this.method = method;
        this.args = DefaultInvocationContext.toNonNullClone(args);
    }

    private static Object[] toNonNullClone(@Nullable Object[] args) {
        return args == null ? NO_ARGS : (Object[])args.clone();
    }

    public static InvocationContext of(Object instance, Method method, @Nullable Object[] args) {
        return new DefaultInvocationContext(System.nanoTime(), Preconditions.checkNotNull((Object)instance, (String)"instance"), (Method)Preconditions.checkNotNull((Object)method, (String)"method"), args);
    }

    public final long getStartTimeNanos() {
        return this.startTimeNanos;
    }

    public final Object getInstance() {
        return this.instance;
    }

    public final Method getMethod() {
        return this.method;
    }

    public final Object[] getArgs() {
        return this.args;
    }

    public String toString() {
        return "DefaultInvocationContext [startTimeNanos=" + this.startTimeNanos + ", instance=" + String.valueOf(this.instance) + ", method=" + String.valueOf(this.method) + "]";
    }
}

