/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event;

import com.palantir.logsafe.Preconditions;
import com.palantir.tritium.event.AbstractInvocationEventHandler;
import com.palantir.tritium.event.DefaultInvocationContext;
import com.palantir.tritium.event.Handlers;
import com.palantir.tritium.event.InstrumentationFilters;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.event.InvocationEventHandler;
import com.palantir.tritium.event.NoOpInvocationEventHandler;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class CompositeInvocationEventHandler
extends AbstractInvocationEventHandler<InvocationContext> {
    private static final InvocationEventHandler<InvocationContext>[] EMPTY = new InvocationEventHandler[0];
    private final InvocationEventHandler<InvocationContext>[] handlers;

    private CompositeInvocationEventHandler(List<InvocationEventHandler<InvocationContext>> handlers) {
        this.handlers = ((List)Preconditions.checkNotNull(handlers, (String)"handlers")).toArray(EMPTY);
        for (InvocationEventHandler<InvocationContext> handler : handlers) {
            Preconditions.checkNotNull(handler, (String)"Null handlers are not allowed");
        }
    }

    public static InvocationEventHandler<InvocationContext> of(List<InvocationEventHandler<InvocationContext>> handlers) {
        if (handlers.isEmpty()) {
            return NoOpInvocationEventHandler.INSTANCE;
        }
        if (handlers.size() == 1) {
            return (InvocationEventHandler)Preconditions.checkNotNull(handlers.get(0), (String)"Null handlers are not allowed");
        }
        return new CompositeInvocationEventHandler(handlers);
    }

    public InvocationContext preInvocation(@NonNull Object instance, @NonNull Method method, @NonNull Object[] args) {
        InvocationContext[] contexts = new InvocationContext[this.handlers.length];
        for (int i = 0; i < this.handlers.length; ++i) {
            contexts[i] = Handlers.preWithEnabledCheck(this.handlers[i], InstrumentationFilters.INSTRUMENT_ALL, instance, method, args);
        }
        return new CompositeInvocationContext(instance, method, args, contexts);
    }

    public void onSuccess(@Nullable InvocationContext context, @Nullable Object result) {
        this.debugIfNullContext(context);
        if (context != null) {
            this.success(((CompositeInvocationContext)context).getContexts(), result);
        }
    }

    private void success(@NonNull InvocationContext[] contexts, @Nullable Object result) {
        for (int i = contexts.length - 1; i > -1; --i) {
            Handlers.onSuccess(this.handlers[i], contexts[i], result);
        }
    }

    public void onFailure(@Nullable InvocationContext context, @NonNull Throwable cause) {
        this.debugIfNullContext(context);
        if (context != null) {
            this.failure(((CompositeInvocationContext)context).getContexts(), cause);
        }
    }

    private void failure(InvocationContext[] contexts, @NonNull Throwable cause) {
        for (int i = contexts.length - 1; i > -1; --i) {
            Handlers.onFailure(this.handlers[i], contexts[i], cause);
        }
    }

    public String toString() {
        return "CompositeInvocationEventHandler{handlers=" + Arrays.toString(this.handlers) + "}";
    }

    static class CompositeInvocationContext
    extends DefaultInvocationContext {
        private final InvocationContext[] contexts;

        CompositeInvocationContext(Object instance, Method method, @Nullable Object[] args, InvocationContext[] contexts) {
            super(System.nanoTime(), instance, method, args);
            this.contexts = (InvocationContext[])Preconditions.checkNotNull((Object)contexts);
        }

        InvocationContext[] getContexts() {
            return this.contexts;
        }
    }
}

