/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.event;

import com.google.errorprone.annotations.InlineMe;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.event.InstrumentationProperties;
import com.palantir.tritium.event.InvocationContext;
import com.palantir.tritium.event.InvocationEventHandler;
import java.util.function.BooleanSupplier;
import org.jspecify.annotations.Nullable;

public abstract class AbstractInvocationEventHandler<C extends InvocationContext>
implements InvocationEventHandler<C> {
    private static final SafeLogger log = SafeLoggerFactory.get(AbstractInvocationEventHandler.class);
    private static final Object[] NO_ARGS = new Object[0];
    private final BooleanSupplier isEnabledSupplier;

    protected AbstractInvocationEventHandler() {
        this(() -> true);
    }

    @Deprecated
    @InlineMe(replacement="this((java.util.function.BooleanSupplier) isEnabledSupplier)")
    protected AbstractInvocationEventHandler(com.palantir.tritium.api.functions.BooleanSupplier isEnabledSupplier) {
        this((BooleanSupplier)isEnabledSupplier);
    }

    protected AbstractInvocationEventHandler(BooleanSupplier isEnabledSupplier) {
        this.isEnabledSupplier = (BooleanSupplier)Preconditions.checkNotNull((Object)isEnabledSupplier, (String)"isEnabledSupplier");
    }

    public final boolean isEnabled() {
        return this.isEnabledSupplier.getAsBoolean();
    }

    protected final void debugIfNullContext(@Nullable InvocationContext context) {
        if (context == null && log.isDebugEnabled()) {
            log.debug("Encountered null metric context, likely due to exception in preInvocation", AbstractInvocationEventHandler.safeClassName(this.getClass()));
        }
    }

    private static SafeArg<String> safeClassName(@Nullable Object obj) {
        return SafeArg.of((String)"class", (Object)(obj == null ? "" : obj.getClass().getName()));
    }

    protected static com.palantir.tritium.api.functions.BooleanSupplier getSystemPropertySupplier(Class<? extends InvocationEventHandler<InvocationContext>> clazz) {
        Preconditions.checkNotNull(clazz, (String)"clazz");
        return InstrumentationProperties.getSystemPropertySupplier(clazz.getName());
    }

    public static Object[] nullToEmpty(@Nullable Object[] args) {
        return args == null ? NO_ARGS : args;
    }
}

