/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.caffeine;

import com.codahale.metrics.Gauge;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.palantir.tritium.metrics.InternalCacheMetrics;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

final class CaffeineStats
implements InternalCacheMetrics.Stats {
    private final Cache<?, ?> cache;
    private final java.util.function.Supplier<CacheStats> stats;

    @VisibleForTesting
    CaffeineStats(Cache<?, ?> cache, java.util.function.Supplier<CacheStats> stats) {
        this.cache = cache;
        this.stats = stats;
    }

    static InternalCacheMetrics.Stats create(Cache<?, ?> cache, long duration, TimeUnit timeUnit) {
        Supplier statsSupplier = Suppliers.memoizeWithExpiration(() -> cache.stats(), (long)duration, (TimeUnit)timeUnit);
        return new CaffeineStats(cache, (java.util.function.Supplier<CacheStats>)statsSupplier);
    }

    private CacheStats stats() {
        return this.stats.get();
    }

    public Gauge<Long> estimatedSize() {
        return () -> this.cache.estimatedSize();
    }

    public Optional<Gauge<Long>> weightedSize() {
        return Optional.of(() -> this.cache.policy().eviction().flatMap(e -> e.weightedSize().stream().boxed().findFirst()).orElse(0L));
    }

    public Optional<Gauge<Long>> maximumSize() {
        return Optional.of(() -> this.cache.policy().eviction().map(Policy.Eviction::getMaximum).orElse(-1L));
    }

    public Gauge<Long> requestCount() {
        return () -> this.stats().requestCount();
    }

    public Gauge<Long> hitCount() {
        return () -> this.stats().hitCount();
    }

    public Gauge<Long> missCount() {
        return () -> this.stats().missCount();
    }

    public Gauge<Long> evictionCount() {
        return () -> this.stats().evictionCount();
    }

    public Gauge<Long> loadSuccessCount() {
        return () -> this.stats().loadSuccessCount();
    }

    public Gauge<Long> loadFailureCount() {
        return () -> this.stats().loadFailureCount();
    }

    public Gauge<Double> loadAverageMillis() {
        return () -> this.stats().averageLoadPenalty() / 1000000.0;
    }
}

