/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.caffeine;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Timer;
import com.google.errorprone.annotations.CheckReturnValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.registry.MetricName;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;

final class CacheMetrics {
    private static final String JAVA_VERSION = System.getProperty("java.version", "unknown");
    private static final String LIBRARY_NAME = "tritium";
    private static final String LIBRARY_VERSION = "0.104.0";
    private final TaggedMetricRegistry registry;

    private CacheMetrics(TaggedMetricRegistry registry) {
        this.registry = registry;
    }

    static CacheMetrics of(TaggedMetricRegistry registry) {
        return new CacheMetrics((TaggedMetricRegistry)Preconditions.checkNotNull((Object)registry, (String)"TaggedMetricRegistry"));
    }

    @CheckReturnValue
    RequestBuilderCacheStage request() {
        return new RequestBuilder();
    }

    @CheckReturnValue
    LoadBuilderCacheStage load() {
        return new LoadBuilder();
    }

    @CheckReturnValue
    EvictionBuilderCacheStage eviction() {
        return new EvictionBuilder();
    }

    @CheckReturnValue
    EvictionWeightBuilderCacheStage evictionWeight() {
        return new EvictionWeightBuilder();
    }

    @CheckReturnValue
    EstimatedSizeBuilderCacheStage estimatedSize() {
        return new EstimatedSizeBuilder();
    }

    @CheckReturnValue
    WeightedSizeBuilderCacheStage weightedSize() {
        return new WeightedSizeBuilder();
    }

    @CheckReturnValue
    MaximumSizeBuilderCacheStage maximumSize() {
        return new MaximumSizeBuilder();
    }

    @CheckReturnValue
    Meter statsDisabled(@Safe String cache) {
        return this.registry.meter(CacheMetrics.statsDisabledMetricName(cache));
    }

    static MetricName statsDisabledMetricName(@Safe String cache) {
        return MetricName.builder().safeName("cache.stats.disabled").putSafeTags("cache", cache).putSafeTags("libraryName", LIBRARY_NAME).putSafeTags("libraryVersion", LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
    }

    public String toString() {
        return "CacheMetrics{registry=" + String.valueOf(this.registry) + "}";
    }

    private final class RequestBuilder
    implements RequestBuilderCacheStage,
    RequestBuilderResultStage,
    RequestBuildStage {
        private String cache;
        private Request_Result result;

        private RequestBuilder() {
        }

        @Override
        public RequestBuilder cache(@Safe String cache) {
            Preconditions.checkState((this.cache == null ? 1 : 0) != 0, (String)"cache is already set");
            this.cache = (String)Preconditions.checkNotNull((Object)cache, (String)"cache is required");
            return this;
        }

        @Override
        public RequestBuilder result(@Safe Request_Result result) {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0, (String)"result is already set");
            this.result = (Request_Result)((Object)Preconditions.checkNotNull((Object)((Object)result), (String)"result is required"));
            return this;
        }

        @Override
        public Meter build() {
            return CacheMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("cache.request").putSafeTags("cache", this.cache).putSafeTags("result", this.result.getValue()).putSafeTags("libraryName", CacheMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", CacheMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class LoadBuilder
    implements LoadBuilderCacheStage,
    LoadBuilderResultStage,
    LoadBuildStage {
        private String cache;
        private Load_Result result;

        private LoadBuilder() {
        }

        @Override
        public LoadBuilder cache(@Safe String cache) {
            Preconditions.checkState((this.cache == null ? 1 : 0) != 0, (String)"cache is already set");
            this.cache = (String)Preconditions.checkNotNull((Object)cache, (String)"cache is required");
            return this;
        }

        @Override
        public LoadBuilder result(@Safe Load_Result result) {
            Preconditions.checkState((this.result == null ? 1 : 0) != 0, (String)"result is already set");
            this.result = (Load_Result)((Object)Preconditions.checkNotNull((Object)((Object)result), (String)"result is required"));
            return this;
        }

        @Override
        public Timer build() {
            return CacheMetrics.this.registry.timer(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("cache.load").putSafeTags("cache", this.cache).putSafeTags("result", this.result.getValue()).putSafeTags("libraryName", CacheMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", CacheMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class EvictionBuilder
    implements EvictionBuilderCacheStage,
    EvictionBuilderCauseStage,
    EvictionBuildStage {
        private String cache;
        private String cause;

        private EvictionBuilder() {
        }

        @Override
        public EvictionBuilder cache(@Safe String cache) {
            Preconditions.checkState((this.cache == null ? 1 : 0) != 0, (String)"cache is already set");
            this.cache = (String)Preconditions.checkNotNull((Object)cache, (String)"cache is required");
            return this;
        }

        @Override
        public EvictionBuilder cause(@Safe String cause) {
            Preconditions.checkState((this.cause == null ? 1 : 0) != 0, (String)"cause is already set");
            this.cause = (String)Preconditions.checkNotNull((Object)cause, (String)"cause is required");
            return this;
        }

        @Override
        public Meter build() {
            return CacheMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("cache.eviction").putSafeTags("cache", this.cache).putSafeTags("cause", this.cause).putSafeTags("libraryName", CacheMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", CacheMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class EvictionWeightBuilder
    implements EvictionWeightBuilderCacheStage,
    EvictionWeightBuilderCauseStage,
    EvictionWeightBuildStage {
        private String cache;
        private String cause;

        private EvictionWeightBuilder() {
        }

        @Override
        public EvictionWeightBuilder cache(@Safe String cache) {
            Preconditions.checkState((this.cache == null ? 1 : 0) != 0, (String)"cache is already set");
            this.cache = (String)Preconditions.checkNotNull((Object)cache, (String)"cache is required");
            return this;
        }

        @Override
        public EvictionWeightBuilder cause(@Safe String cause) {
            Preconditions.checkState((this.cause == null ? 1 : 0) != 0, (String)"cause is already set");
            this.cause = (String)Preconditions.checkNotNull((Object)cause, (String)"cause is required");
            return this;
        }

        @Override
        public Meter build() {
            return CacheMetrics.this.registry.meter(this.buildMetricName());
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("cache.eviction.weight").putSafeTags("cache", this.cache).putSafeTags("cause", this.cause).putSafeTags("libraryName", CacheMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", CacheMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class EstimatedSizeBuilder
    implements EstimatedSizeBuilderCacheStage,
    EstimatedSizeBuildStage {
        private String cache;

        private EstimatedSizeBuilder() {
        }

        @Override
        public EstimatedSizeBuilder cache(@Safe String cache) {
            Preconditions.checkState((this.cache == null ? 1 : 0) != 0, (String)"cache is already set");
            this.cache = (String)Preconditions.checkNotNull((Object)cache, (String)"cache is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            CacheMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("cache.estimated.size").putSafeTags("cache", this.cache).putSafeTags("libraryName", CacheMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", CacheMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class WeightedSizeBuilder
    implements WeightedSizeBuilderCacheStage,
    WeightedSizeBuildStage {
        private String cache;

        private WeightedSizeBuilder() {
        }

        @Override
        public WeightedSizeBuilder cache(@Safe String cache) {
            Preconditions.checkState((this.cache == null ? 1 : 0) != 0, (String)"cache is already set");
            this.cache = (String)Preconditions.checkNotNull((Object)cache, (String)"cache is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            CacheMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("cache.weighted.size").putSafeTags("cache", this.cache).putSafeTags("libraryName", CacheMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", CacheMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    private final class MaximumSizeBuilder
    implements MaximumSizeBuilderCacheStage,
    MaximumSizeBuildStage {
        private String cache;

        private MaximumSizeBuilder() {
        }

        @Override
        public MaximumSizeBuilder cache(@Safe String cache) {
            Preconditions.checkState((this.cache == null ? 1 : 0) != 0, (String)"cache is already set");
            this.cache = (String)Preconditions.checkNotNull((Object)cache, (String)"cache is required");
            return this;
        }

        @Override
        public void build(Gauge<? extends Number> gauge) {
            CacheMetrics.this.registry.registerWithReplacement(this.buildMetricName(), gauge);
        }

        @Override
        public MetricName buildMetricName() {
            return MetricName.builder().safeName("cache.maximum.size").putSafeTags("cache", this.cache).putSafeTags("libraryName", CacheMetrics.LIBRARY_NAME).putSafeTags("libraryVersion", CacheMetrics.LIBRARY_VERSION).putSafeTags("javaVersion", JAVA_VERSION).build();
        }
    }

    static interface MaximumSizeBuilderCacheStage {
        @CheckReturnValue
        public MaximumSizeBuildStage cache(@Safe String var1);
    }

    static interface MaximumSizeBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface WeightedSizeBuilderCacheStage {
        @CheckReturnValue
        public WeightedSizeBuildStage cache(@Safe String var1);
    }

    static interface WeightedSizeBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface EstimatedSizeBuilderCacheStage {
        @CheckReturnValue
        public EstimatedSizeBuildStage cache(@Safe String var1);
    }

    static interface EstimatedSizeBuildStage {
        public void build(Gauge<? extends Number> var1);

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface EvictionWeightBuilderCauseStage {
        @CheckReturnValue
        public EvictionWeightBuildStage cause(@Safe String var1);
    }

    static interface EvictionWeightBuilderCacheStage {
        @CheckReturnValue
        public EvictionWeightBuilderCauseStage cache(@Safe String var1);
    }

    static interface EvictionWeightBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface EvictionBuilderCauseStage {
        @CheckReturnValue
        public EvictionBuildStage cause(@Safe String var1);
    }

    static interface EvictionBuilderCacheStage {
        @CheckReturnValue
        public EvictionBuilderCauseStage cache(@Safe String var1);
    }

    static interface EvictionBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static interface LoadBuilderResultStage {
        @CheckReturnValue
        public LoadBuildStage result(@Safe Load_Result var1);
    }

    static interface LoadBuilderCacheStage {
        @CheckReturnValue
        public LoadBuilderResultStage cache(@Safe String var1);
    }

    static interface LoadBuildStage {
        @CheckReturnValue
        public Timer build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static enum Load_Result {
        SUCCESS("success"),
        FAILURE("failure");

        private final String value;

        private Load_Result(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }

    static interface RequestBuilderResultStage {
        @CheckReturnValue
        public RequestBuildStage result(@Safe Request_Result var1);
    }

    static interface RequestBuilderCacheStage {
        @CheckReturnValue
        public RequestBuilderResultStage cache(@Safe String var1);
    }

    static interface RequestBuildStage {
        @CheckReturnValue
        public Meter build();

        @CheckReturnValue
        public MetricName buildMetricName();
    }

    static enum Request_Result {
        HIT("hit"),
        MISS("miss");

        private final String value;

        private Request_Result(String value) {
            this.value = value;
        }

        private String getValue() {
            return this.value;
        }
    }
}

