/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.caffeine;

import com.codahale.metrics.Gauge;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.tritium.metrics.InternalCacheMetrics;
import com.palantir.tritium.metrics.caffeine.CaffeineCacheStats;
import com.palantir.tritium.metrics.registry.MetricName;

final class CaffeineCacheTaggedMetrics {
    private final Cache<?, ?> cache;
    private final String cacheName;

    private CaffeineCacheTaggedMetrics(Cache<?, ?> cache, @Safe String cacheName) {
        String name = ((String)Preconditions.checkNotNull((Object)cacheName, (String)"cacheName")).trim();
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (String)"Cache name cannot be blank or empty");
        this.cache = (Cache)Preconditions.checkNotNull(cache, (String)"cache");
        this.cacheName = name;
    }

    static CaffeineCacheTaggedMetrics create(Cache<?, ?> cache, @Safe String cacheName) {
        return new CaffeineCacheTaggedMetrics(cache, cacheName);
    }

    ImmutableMap<MetricName, Gauge<?>> getMetrics() {
        return CaffeineCacheStats.createCacheGauges(this.cache, InternalCacheMetrics.taggedMetricName((String)this.cacheName));
    }
}

