/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tritium.metrics.caffeine;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.palantir.logsafe.Arg;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.Safe;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.logger.SafeLogger;
import com.palantir.logsafe.logger.SafeLoggerFactory;
import com.palantir.tritium.metrics.InternalCacheMetrics;
import com.palantir.tritium.metrics.MetricRegistries;
import com.palantir.tritium.metrics.caffeine.CacheMetrics;
import com.palantir.tritium.metrics.caffeine.CaffeineCacheMetrics;
import com.palantir.tritium.metrics.caffeine.CaffeineCacheTaggedMetrics;
import com.palantir.tritium.metrics.caffeine.CaffeineStats;
import com.palantir.tritium.metrics.registry.TaggedMetricRegistry;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class CaffeineCacheStats {
    private static final SafeLogger log = SafeLoggerFactory.get(CaffeineCacheStats.class);

    private CaffeineCacheStats() {
    }

    @Deprecated
    public static void registerCache(MetricRegistry registry, Cache<?, ?> cache, String name) {
        Preconditions.checkNotNull((Object)registry, (String)"registry");
        Preconditions.checkNotNull(cache, (String)"cache");
        Preconditions.checkNotNull((Object)name, (String)"name");
        if (cache.policy().isRecordingStats()) {
            CaffeineCacheMetrics.create(cache, name).getMetrics().forEach((key, value) -> MetricRegistries.registerWithReplacement((MetricRegistry)registry, (String)key, (Metric)value));
        } else {
            CaffeineCacheStats.warnNotRecordingStats(name, registry.meter(MetricRegistry.name((String)name, (String[])new String[]{CacheMetrics.statsDisabledMetricName(name).safeName()})));
        }
    }

    @Deprecated
    public static void registerCache(TaggedMetricRegistry registry, Cache<?, ?> cache, @Safe String name) {
        Preconditions.checkNotNull((Object)registry, (String)"registry");
        Preconditions.checkNotNull(cache, (String)"cache");
        Preconditions.checkNotNull((Object)name, (String)"name");
        if (cache.policy().isRecordingStats()) {
            CaffeineCacheTaggedMetrics.create(cache, name).getMetrics().forEach((arg_0, arg_1) -> ((TaggedMetricRegistry)registry).registerWithReplacement(arg_0, arg_1));
        } else {
            CaffeineCacheStats.warnNotRecordingStats(name, CacheMetrics.of(registry).statsDisabled(name));
        }
    }

    private static void warnNotRecordingStats(@Safe String name, Meter counter) {
        counter.mark();
        log.warn("Registered cache does not have stats recording enabled, stats will always be zero. To enable cache metrics, stats recording must be enabled when constructing the cache: Caffeine.newBuilder().recordStats()", (Arg)SafeArg.of((String)"cacheName", (Object)name));
    }

    static <K> ImmutableMap<K, Gauge<?>> createCacheGauges(Cache<?, ?> cache, Function<String, K> metricNamer) {
        return InternalCacheMetrics.createMetrics((InternalCacheMetrics.Stats)CaffeineStats.create(cache, 1L, TimeUnit.SECONDS), metricNamer);
    }
}

