/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.undertow;

import com.palantir.logsafe.Preconditions;
import com.palantir.tracing.CloseableSpan;
import com.palantir.tracing.DetachedSpan;
import com.palantir.tracing.undertow.StatusCodeTagTranslator;
import com.palantir.tracing.undertow.UndertowTracing;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;

public final class TracedStateHandler
implements HttpHandler {
    private final HttpHandler delegate;

    public TracedStateHandler(HttpHandler delegate) {
        this.delegate = (HttpHandler)Preconditions.checkNotNull((Object)delegate, (String)"A delegate HttpHandler is required");
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        DetachedSpan detachedSpan = UndertowTracing.getOrInitializeRequestTrace(exchange, "Undertow Request", StatusCodeTagTranslator.INSTANCE);
        try (CloseableSpan ignored = detachedSpan.attach();){
            this.delegate.handleRequest(exchange);
        }
    }

    public String toString() {
        return "TracedStateHandler{" + String.valueOf(this.delegate) + "}";
    }
}

