/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.api;

import com.palantir.tracing.api.ImmutableOpenSpan;
import com.palantir.tracing.api.SpanType;
import java.time.Instant;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable
public abstract class OpenSpan {
    @Value.Parameter
    public abstract String getOperation();

    @Value.Parameter
    public abstract long getStartTimeMicroSeconds();

    @Value.Parameter
    public abstract long getStartClockNanoSeconds();

    @Value.Parameter
    public abstract Optional<String> getParentSpanId();

    @Deprecated
    public Optional<String> getOriginatingSpanId() {
        return Optional.empty();
    }

    @Value.Parameter
    public abstract String getSpanId();

    @Value.Parameter
    public abstract SpanType type();

    public static Builder builder() {
        return new Builder().startTimeMicroSeconds(OpenSpan.getNowInMicroSeconds()).startClockNanoSeconds(System.nanoTime());
    }

    @Deprecated
    public static OpenSpan of(String operation, String spanId, SpanType type, Optional<String> parentSpanId, Optional<String> _originatingSpanId) {
        return ImmutableOpenSpan.of(operation, OpenSpan.getNowInMicroSeconds(), System.nanoTime(), parentSpanId, spanId, type);
    }

    public static OpenSpan of(String operation, String spanId, SpanType type, Optional<String> parentSpanId) {
        return ImmutableOpenSpan.of(operation, OpenSpan.getNowInMicroSeconds(), System.nanoTime(), parentSpanId, spanId, type);
    }

    private static long getNowInMicroSeconds() {
        Instant now = Instant.now();
        return 1000000L * now.getEpochSecond() + (long)(now.getNano() / 1000);
    }

    public static class Builder
    extends ImmutableOpenSpan.Builder {
    }
}

