/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.tracing.api;

import com.palantir.tracing.api.Span;
import com.palantir.tracing.api.SpanType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@Generated(from="Span", generator="Immutables")
final class ImmutableSpan
extends Span {
    private final String traceId;
    private final @Nullable String parentSpanId;
    private final String spanId;
    private final SpanType type;
    private final String operation;
    private final long startTimeMicroSeconds;
    private final long durationNanoSeconds;
    private final Map<String, String> metadata;

    private ImmutableSpan(String traceId, @Nullable String parentSpanId, String spanId, SpanType type, String operation, long startTimeMicroSeconds, long durationNanoSeconds, Map<String, String> metadata) {
        this.traceId = traceId;
        this.parentSpanId = parentSpanId;
        this.spanId = spanId;
        this.type = type;
        this.operation = operation;
        this.startTimeMicroSeconds = startTimeMicroSeconds;
        this.durationNanoSeconds = durationNanoSeconds;
        this.metadata = metadata;
    }

    @Override
    public String getTraceId() {
        return this.traceId;
    }

    @Override
    public Optional<String> getParentSpanId() {
        return Optional.ofNullable(this.parentSpanId);
    }

    @Override
    public String getSpanId() {
        return this.spanId;
    }

    @Override
    public SpanType type() {
        return this.type;
    }

    @Override
    public String getOperation() {
        return this.operation;
    }

    @Override
    public long getStartTimeMicroSeconds() {
        return this.startTimeMicroSeconds;
    }

    @Override
    public long getDurationNanoSeconds() {
        return this.durationNanoSeconds;
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public final ImmutableSpan withTraceId(String value) {
        String newValue = Objects.requireNonNull(value, "traceId");
        if (this.traceId.equals(newValue)) {
            return this;
        }
        return new ImmutableSpan(newValue, this.parentSpanId, this.spanId, this.type, this.operation, this.startTimeMicroSeconds, this.durationNanoSeconds, this.metadata);
    }

    public final ImmutableSpan withParentSpanId(String value) {
        String newValue = Objects.requireNonNull(value, "parentSpanId");
        if (Objects.equals(this.parentSpanId, newValue)) {
            return this;
        }
        return new ImmutableSpan(this.traceId, newValue, this.spanId, this.type, this.operation, this.startTimeMicroSeconds, this.durationNanoSeconds, this.metadata);
    }

    public final ImmutableSpan withParentSpanId(Optional<String> optional) {
        @Nullable String value = optional.orElse(null);
        if (Objects.equals(this.parentSpanId, value)) {
            return this;
        }
        return new ImmutableSpan(this.traceId, value, this.spanId, this.type, this.operation, this.startTimeMicroSeconds, this.durationNanoSeconds, this.metadata);
    }

    public final ImmutableSpan withSpanId(String value) {
        String newValue = Objects.requireNonNull(value, "spanId");
        if (this.spanId.equals(newValue)) {
            return this;
        }
        return new ImmutableSpan(this.traceId, this.parentSpanId, newValue, this.type, this.operation, this.startTimeMicroSeconds, this.durationNanoSeconds, this.metadata);
    }

    public final ImmutableSpan withType(SpanType value) {
        SpanType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableSpan(this.traceId, this.parentSpanId, this.spanId, newValue, this.operation, this.startTimeMicroSeconds, this.durationNanoSeconds, this.metadata);
    }

    public final ImmutableSpan withOperation(String value) {
        String newValue = Objects.requireNonNull(value, "operation");
        if (this.operation.equals(newValue)) {
            return this;
        }
        return new ImmutableSpan(this.traceId, this.parentSpanId, this.spanId, this.type, newValue, this.startTimeMicroSeconds, this.durationNanoSeconds, this.metadata);
    }

    public final ImmutableSpan withStartTimeMicroSeconds(long value) {
        if (this.startTimeMicroSeconds == value) {
            return this;
        }
        return new ImmutableSpan(this.traceId, this.parentSpanId, this.spanId, this.type, this.operation, value, this.durationNanoSeconds, this.metadata);
    }

    public final ImmutableSpan withDurationNanoSeconds(long value) {
        if (this.durationNanoSeconds == value) {
            return this;
        }
        return new ImmutableSpan(this.traceId, this.parentSpanId, this.spanId, this.type, this.operation, this.startTimeMicroSeconds, value, this.metadata);
    }

    public final ImmutableSpan withMetadata(Map<String, ? extends String> entries) {
        if (this.metadata == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableSpan.createUnmodifiableMap(true, false, entries);
        return new ImmutableSpan(this.traceId, this.parentSpanId, this.spanId, this.type, this.operation, this.startTimeMicroSeconds, this.durationNanoSeconds, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpan && this.equalsByValue((ImmutableSpan)another);
    }

    private boolean equalsByValue(ImmutableSpan another) {
        return this.traceId.equals(another.traceId) && Objects.equals(this.parentSpanId, another.parentSpanId) && this.spanId.equals(another.spanId) && this.type.equals((Object)another.type) && this.operation.equals(another.operation) && this.startTimeMicroSeconds == another.startTimeMicroSeconds && this.durationNanoSeconds == another.durationNanoSeconds && this.metadata.equals(another.metadata);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.traceId.hashCode();
        h += (h << 5) + Objects.hashCode(this.parentSpanId);
        h += (h << 5) + this.spanId.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.operation.hashCode();
        h += (h << 5) + Long.hashCode(this.startTimeMicroSeconds);
        h += (h << 5) + Long.hashCode(this.durationNanoSeconds);
        h += (h << 5) + this.metadata.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Span{");
        builder.append("traceId=").append(this.traceId);
        if (this.parentSpanId != null) {
            builder.append(", ");
            builder.append("parentSpanId=").append(this.parentSpanId);
        }
        builder.append(", ");
        builder.append("spanId=").append(this.spanId);
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("operation=").append(this.operation);
        builder.append(", ");
        builder.append("startTimeMicroSeconds=").append(this.startTimeMicroSeconds);
        builder.append(", ");
        builder.append("durationNanoSeconds=").append(this.durationNanoSeconds);
        builder.append(", ");
        builder.append("metadata=").append(this.metadata);
        return builder.append("}").toString();
    }

    public static ImmutableSpan copyOf(Span instance) {
        if (instance instanceof ImmutableSpan) {
            return (ImmutableSpan)instance;
        }
        return new Span.Builder().from(instance).build();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="Span", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_TRACE_ID = 1L;
        private static final long INIT_BIT_SPAN_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private static final long INIT_BIT_OPERATION = 8L;
        private static final long INIT_BIT_START_TIME_MICRO_SECONDS = 16L;
        private static final long INIT_BIT_DURATION_NANO_SECONDS = 32L;
        private long initBits = 63L;
        private @Nullable String traceId;
        private @Nullable String parentSpanId;
        private @Nullable String spanId;
        private @Nullable SpanType type;
        private @Nullable String operation;
        private long startTimeMicroSeconds;
        private long durationNanoSeconds;
        private Map<String, String> metadata = new LinkedHashMap<String, String>();

        public Builder() {
            if (!(this instanceof Span.Builder)) {
                throw new UnsupportedOperationException("Use: new Span.Builder()");
            }
        }

        public final Span.Builder from(Span instance) {
            Objects.requireNonNull(instance, "instance");
            this.traceId(instance.getTraceId());
            Optional<String> parentSpanIdOptional = instance.getParentSpanId();
            if (parentSpanIdOptional.isPresent()) {
                this.parentSpanId(parentSpanIdOptional);
            }
            this.spanId(instance.getSpanId());
            this.type(instance.type());
            this.operation(instance.getOperation());
            this.startTimeMicroSeconds(instance.getStartTimeMicroSeconds());
            this.durationNanoSeconds(instance.getDurationNanoSeconds());
            this.putAllMetadata(instance.getMetadata());
            return (Span.Builder)this;
        }

        public final Span.Builder traceId(String traceId) {
            this.traceId = Objects.requireNonNull(traceId, "traceId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Span.Builder)this;
        }

        public final Span.Builder parentSpanId(String parentSpanId) {
            this.parentSpanId = Objects.requireNonNull(parentSpanId, "parentSpanId");
            return (Span.Builder)this;
        }

        public final Span.Builder parentSpanId(Optional<String> parentSpanId) {
            this.parentSpanId = parentSpanId.orElse(null);
            return (Span.Builder)this;
        }

        public final Span.Builder spanId(String spanId) {
            this.spanId = Objects.requireNonNull(spanId, "spanId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Span.Builder)this;
        }

        public final Span.Builder type(SpanType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return (Span.Builder)this;
        }

        public final Span.Builder operation(String operation) {
            this.operation = Objects.requireNonNull(operation, "operation");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return (Span.Builder)this;
        }

        public final Span.Builder startTimeMicroSeconds(long startTimeMicroSeconds) {
            this.startTimeMicroSeconds = startTimeMicroSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return (Span.Builder)this;
        }

        public final Span.Builder durationNanoSeconds(long durationNanoSeconds) {
            this.durationNanoSeconds = durationNanoSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return (Span.Builder)this;
        }

        public final Span.Builder putMetadata(String key, String value) {
            this.metadata.put(Objects.requireNonNull(key, "metadata key"), Objects.requireNonNull(value, value == null ? "metadata value for key: " + key : null));
            return (Span.Builder)this;
        }

        public final Span.Builder putMetadata(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "metadata value for key: " + k : null));
            return (Span.Builder)this;
        }

        public final Span.Builder metadata(Map<String, ? extends String> entries) {
            this.metadata.clear();
            return this.putAllMetadata(entries);
        }

        public final Span.Builder putAllMetadata(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.metadata.put(Objects.requireNonNull(k, "metadata key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "metadata value for key: " + k : null));
            }
            return (Span.Builder)this;
        }

        public ImmutableSpan build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSpan(this.traceId, this.parentSpanId, this.spanId, this.type, this.operation, this.startTimeMicroSeconds, this.durationNanoSeconds, ImmutableSpan.createUnmodifiableMap(false, false, this.metadata));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("traceId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("spanId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("operation");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("startTimeMicroSeconds");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("durationNanoSeconds");
            }
            return "Cannot build Span, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

